/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.message.KRaftVersionRecord;
import org.apache.kafka.common.message.LeaderChangeMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.Endpoints;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.RaftUtil;
import org.apache.kafka.raft.ReplicaKey;
import org.apache.kafka.raft.VoterSet;
import org.apache.kafka.raft.errors.NotLeaderException;
import org.apache.kafka.raft.internals.AddVoterHandlerState;
import org.apache.kafka.raft.internals.BatchAccumulator;
import org.apache.kafka.raft.internals.KRaftVersionUpgrade;
import org.apache.kafka.raft.internals.KafkaRaftMetrics;
import org.apache.kafka.raft.internals.RemoveVoterHandlerState;
import org.apache.kafka.server.common.KRaftVersion;
import org.slf4j.Logger;

public class LeaderState<T>
implements EpochState {
    static final long OBSERVER_SESSION_TIMEOUT_MS = 300000L;
    static final double CHECK_QUORUM_TIMEOUT_FACTOR = 1.5;
    private final VoterSet.VoterNode localVoterNode;
    private final int epoch;
    private final long epochStartOffset;
    private final Set<Integer> grantingVoters;
    private final VoterSet voterSetAtEpochStart;
    private final OptionalLong offsetOfVotersAtEpochStart;
    private final KRaftVersion kraftVersionAtEpochStart;
    private Optional<LogOffsetMetadata> highWatermark = Optional.empty();
    private Map<Integer, ReplicaState> voterStates = new HashMap<Integer, ReplicaState>();
    private Optional<AddVoterHandlerState> addVoterHandlerState = Optional.empty();
    private Optional<RemoveVoterHandlerState> removeVoterHandlerState = Optional.empty();
    private final Map<ReplicaKey, ReplicaState> observerStates = new HashMap<ReplicaKey, ReplicaState>();
    private final Logger log;
    private final BatchAccumulator<T> accumulator;
    private final Set<Integer> fetchedVoters = new HashSet<Integer>();
    private final Timer checkQuorumTimer;
    private final int checkQuorumTimeoutMs;
    private final Timer beginQuorumEpochTimer;
    private final int beginQuorumEpochTimeoutMs;
    private final KafkaRaftMetrics kafkaRaftMetrics;
    private volatile boolean resignRequested = false;
    private final AtomicReference<KRaftVersionUpgrade> kraftVersionUpgradeState = new AtomicReference<KRaftVersionUpgrade>(KRaftVersionUpgrade.empty());

    protected LeaderState(Time time, VoterSet.VoterNode localVoterNode, int epoch, long epochStartOffset, VoterSet voterSetAtEpochStart, OptionalLong offsetOfVotersAtEpochStart, KRaftVersion kraftVersionAtEpochStart, Set<Integer> grantingVoters, BatchAccumulator<T> accumulator, int fetchTimeoutMs, LogContext logContext, KafkaRaftMetrics kafkaRaftMetrics) {
        if (localVoterNode.voterKey().directoryId().isEmpty()) {
            throw new IllegalArgumentException(String.format("Unknown local replica directory id: %s", localVoterNode));
        }
        if (!voterSetAtEpochStart.isVoter(localVoterNode.voterKey())) {
            throw new IllegalArgumentException(String.format("Local replica %s is not a voter in %s", localVoterNode, voterSetAtEpochStart));
        }
        this.localVoterNode = localVoterNode;
        this.epoch = epoch;
        this.epochStartOffset = epochStartOffset;
        for (VoterSet.VoterNode voterNode : voterSetAtEpochStart.voterNodes()) {
            boolean hasAcknowledgedLeader = voterNode.isVoter(localVoterNode.voterKey());
            this.voterStates.put(voterNode.voterKey().id(), new ReplicaState(voterNode.voterKey(), hasAcknowledgedLeader, voterNode.listeners()));
        }
        this.grantingVoters = Set.copyOf(grantingVoters);
        this.log = logContext.logger(LeaderState.class);
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator must be non-null");
        this.checkQuorumTimeoutMs = (int)((double)fetchTimeoutMs * 1.5);
        this.checkQuorumTimer = time.timer((long)this.checkQuorumTimeoutMs);
        this.beginQuorumEpochTimeoutMs = fetchTimeoutMs / 2;
        this.beginQuorumEpochTimer = time.timer(0L);
        this.voterSetAtEpochStart = voterSetAtEpochStart;
        this.offsetOfVotersAtEpochStart = offsetOfVotersAtEpochStart;
        this.kraftVersionAtEpochStart = kraftVersionAtEpochStart;
        kafkaRaftMetrics.addLeaderMetrics();
        this.kafkaRaftMetrics = kafkaRaftMetrics;
        if (!kraftVersionAtEpochStart.isReconfigSupported()) {
            VoterSet updatedVoters = voterSetAtEpochStart.updateVoterIgnoringDirectoryId(localVoterNode).orElseThrow(() -> new IllegalStateException(String.format("Unable to update voter set %s with the latest leader information %s", voterSetAtEpochStart, localVoterNode)));
            this.kraftVersionUpgradeState.set(new KRaftVersionUpgrade.Voters(updatedVoters));
        }
    }

    public long timeUntilBeginQuorumEpochTimerExpires(long currentTimeMs) {
        this.beginQuorumEpochTimer.update(currentTimeMs);
        return this.beginQuorumEpochTimer.remainingMs();
    }

    public void resetBeginQuorumEpochTimer(long currentTimeMs) {
        this.beginQuorumEpochTimer.update(currentTimeMs);
        this.beginQuorumEpochTimer.reset((long)this.beginQuorumEpochTimeoutMs);
    }

    public long timeUntilCheckQuorumExpires(long currentTimeMs) {
        if (this.voterStates.size() == 1) {
            return Long.MAX_VALUE;
        }
        this.checkQuorumTimer.update(currentTimeMs);
        long remainingMs = this.checkQuorumTimer.remainingMs();
        if (remainingMs == 0L) {
            this.log.info("Did not receive fetch request from the majority of the voters within {}ms. Current fetched voters are {}, and voters are {}", new Object[]{this.checkQuorumTimeoutMs, this.fetchedVoters, this.voterStates.values().stream().map(voter -> voter.replicaKey).collect(Collectors.toUnmodifiableSet())});
        }
        return remainingMs;
    }

    public void updateCheckQuorumForFollowingVoter(ReplicaKey replicaKey, long currentTimeMs) {
        this.updateFetchedVoters(replicaKey);
        int majority = this.voterStates.size() / 2 + 1;
        if (this.voterStates.containsKey(this.localVoterNode.voterKey().id())) {
            --majority;
        }
        if (this.fetchedVoters.size() >= majority) {
            this.fetchedVoters.clear();
            this.checkQuorumTimer.update(currentTimeMs);
            this.checkQuorumTimer.reset((long)this.checkQuorumTimeoutMs);
        }
    }

    private void updateFetchedVoters(ReplicaKey replicaKey) {
        if (replicaKey.id() == this.localVoterNode.voterKey().id()) {
            throw new IllegalArgumentException("Received a FETCH/FETCH_SNAPSHOT request from the leader itself.");
        }
        ReplicaState state = this.voterStates.get(replicaKey.id());
        if (state != null && state.matchesKey(replicaKey)) {
            this.fetchedVoters.add(replicaKey.id());
        }
    }

    public BatchAccumulator<T> accumulator() {
        return this.accumulator;
    }

    public Optional<AddVoterHandlerState> addVoterHandlerState() {
        return this.addVoterHandlerState;
    }

    public void resetAddVoterHandlerState(Errors error, String message, Optional<AddVoterHandlerState> state) {
        this.addVoterHandlerState.ifPresent(handlerState -> handlerState.future().complete(RaftUtil.addVoterResponse(error, message)));
        this.addVoterHandlerState = state;
        this.updateUncommittedVoterChangeMetric();
    }

    public Optional<RemoveVoterHandlerState> removeVoterHandlerState() {
        return this.removeVoterHandlerState;
    }

    public void resetRemoveVoterHandlerState(Errors error, String message, Optional<RemoveVoterHandlerState> state) {
        this.removeVoterHandlerState.ifPresent(handlerState -> handlerState.future().complete(RaftUtil.removeVoterResponse(error, message)));
        this.removeVoterHandlerState = state;
        this.updateUncommittedVoterChangeMetric();
    }

    private void updateUncommittedVoterChangeMetric() {
        this.kafkaRaftMetrics.updateUncommittedVoterChange(this.addVoterHandlerState.isPresent() || this.removeVoterHandlerState.isPresent());
    }

    public long maybeExpirePendingOperation(long currentTimeMs) {
        long timeUntilRemoveVoterExpiration;
        long timeUntilAddVoterExpiration = this.addVoterHandlerState().map(state -> state.timeUntilOperationExpiration(currentTimeMs)).orElse(Long.MAX_VALUE);
        if (timeUntilAddVoterExpiration == 0L) {
            this.resetAddVoterHandlerState(Errors.REQUEST_TIMED_OUT, null, Optional.empty());
        }
        if ((timeUntilRemoveVoterExpiration = this.removeVoterHandlerState().map(state -> state.timeUntilOperationExpiration(currentTimeMs)).orElse(Long.MAX_VALUE).longValue()) == 0L) {
            this.resetRemoveVoterHandlerState(Errors.REQUEST_TIMED_OUT, null, Optional.empty());
        }
        return Math.min(this.addVoterHandlerState().map(state -> state.timeUntilOperationExpiration(currentTimeMs)).orElse(Long.MAX_VALUE), this.removeVoterHandlerState().map(state -> state.timeUntilOperationExpiration(currentTimeMs)).orElse(Long.MAX_VALUE));
    }

    public boolean isOperationPending(long currentTimeMs) {
        this.maybeExpirePendingOperation(currentTimeMs);
        return this.addVoterHandlerState.isPresent() || this.removeVoterHandlerState.isPresent();
    }

    private static List<LeaderChangeMessage.Voter> convertToVoters(Set<Integer> voterIds) {
        return voterIds.stream().map(follower -> new LeaderChangeMessage.Voter().setVoterId(follower.intValue())).collect(Collectors.toList());
    }

    private static MemoryRecordsBuilder createControlRecordsBuilder(long baseOffset, int epoch, Compression compression, ByteBuffer buffer, long currentTimeMs) {
        return new MemoryRecordsBuilder(buffer, 2, compression, TimestampType.CREATE_TIME, baseOffset, currentTimeMs, -1L, -1, -1, false, true, epoch, buffer.capacity());
    }

    public void appendStartOfEpochControlRecords(long currentTimeMs) {
        List<LeaderChangeMessage.Voter> voters = LeaderState.convertToVoters(this.voterStates.keySet());
        List<LeaderChangeMessage.Voter> grantingVoters = LeaderState.convertToVoters(this.grantingVoters());
        LeaderChangeMessage leaderChangeMessage = new LeaderChangeMessage().setVersion((short)0).setLeaderId(this.election().leaderId()).setVoters(voters).setGrantingVoters(grantingVoters);
        this.accumulator.appendControlMessages((baseOffset, epoch, compression, buffer) -> {
            try (MemoryRecordsBuilder builder = LeaderState.createControlRecordsBuilder(baseOffset, epoch, compression, buffer, currentTimeMs);){
                long offset2;
                builder.appendLeaderChangeMessage(currentTimeMs, leaderChangeMessage);
                if (this.kraftVersionAtEpochStart.isReconfigSupported() && ((offset2 = this.offsetOfVotersAtEpochStart.orElseThrow(() -> new IllegalStateException(String.format("The %s is %s but there is no voter set in the log or checkpoint %s", "kraft.version", this.kraftVersionAtEpochStart, this.voterSetAtEpochStart)))) == -1L || this.voterSetAtEpochStart.voterNodeNeedsUpdate(this.localVoterNode))) {
                    VoterSet updatedVoterSet = this.voterSetAtEpochStart.updateVoter(this.localVoterNode).orElseThrow(() -> new IllegalStateException(String.format("Update expected for leader node %s and voter set %s", this.localVoterNode, this.voterSetAtEpochStart)));
                    builder.appendKRaftVersionMessage(currentTimeMs, new KRaftVersionRecord().setVersion(this.kraftVersionAtEpochStart.kraftVersionRecordVersion()).setKRaftVersion(this.kraftVersionAtEpochStart.featureLevel()));
                    builder.appendVotersMessage(currentTimeMs, updatedVoterSet.toVotersRecord(this.kraftVersionAtEpochStart.votersRecordVersion()));
                }
                MemoryRecords offset2 = builder.build();
                return offset2;
            }
        });
    }

    public long appendVotersRecord(VoterSet voters, long currentTimeMs) {
        return this.accumulator.appendVotersRecord(voters.toVotersRecord((short)0), currentTimeMs);
    }

    public boolean compareAndSetVolatileVoters(KRaftVersionUpgrade.Voters oldVoters, KRaftVersionUpgrade.Voters newVoters) {
        return this.kraftVersionUpgradeState.compareAndSet(oldVoters, newVoters);
    }

    public Optional<KRaftVersionUpgrade.Voters> volatileVoters() {
        return this.kraftVersionUpgradeState.get().toVoters();
    }

    public Optional<KRaftVersionUpgrade.Version> requestedKRaftVersion() {
        return this.kraftVersionUpgradeState.get().toVersion();
    }

    public boolean isResignRequested() {
        return this.resignRequested;
    }

    public boolean isReplicaCaughtUp(ReplicaKey replicaKey, long currentTimeMs) {
        long anHourInMs = TimeUnit.HOURS.toMillis(1L);
        return Optional.ofNullable(this.observerStates.get(replicaKey)).map(state -> state.lastCaughtUpTimestamp > 0L && state.lastFetchTimestamp > 0L && state.lastFetchTimestamp > currentTimeMs - anHourInMs).orElse(false);
    }

    public void requestResign() {
        this.resignRequested = true;
    }

    public boolean maybeAppendUpgradedKRaftVersion(int currentEpoch, KRaftVersion newVersion, KRaftVersion persistedVersion, VoterSet persistedVoters, boolean validateOnly, long currentTimeMs) {
        this.validateEpoch(currentEpoch);
        Optional<KRaftVersionUpgrade.Version> pendingVersion = this.kraftVersionUpgradeState.get().toVersion();
        if (pendingVersion.isPresent()) {
            if (pendingVersion.get().kraftVersion().equals((Object)newVersion)) {
                return false;
            }
            throw new InvalidUpdateVersionException(String.format("Invalid concurrent upgrade of %s from version %s to %s", "kraft.version", pendingVersion.get(), newVersion));
        }
        if (persistedVersion.equals((Object)newVersion)) {
            return false;
        }
        if (persistedVersion.isMoreThan(newVersion)) {
            throw new InvalidUpdateVersionException(String.format("Invalid upgrade of %s from version %s to %s because the new version is a downgrade", "kraft.version", persistedVersion, newVersion));
        }
        KRaftVersionUpgrade.Voters inMemoryVoters = this.kraftVersionUpgradeState.get().toVoters().orElseThrow(() -> new InvalidUpdateVersionException(String.format("Invalid upgrade of %s from version %s to %s", "kraft.version", persistedVersion, newVersion)));
        if (!inMemoryVoters.voters().voterIds().equals(persistedVoters.voterIds())) {
            throw new IllegalStateException(String.format("Unable to update %s to %s due to missing voters %s compared to %s", "kraft.version", newVersion, inMemoryVoters.voters().voterIds(), persistedVoters.voterIds()));
        }
        if (!inMemoryVoters.voters().supportsVersion(newVersion)) {
            this.log.info("Not all voters support kraft version {}: {}", (Object)newVersion, (Object)inMemoryVoters.voters());
            throw new InvalidUpdateVersionException(String.format("Invalid upgrade of %s to %s because not all of the voters support it", "kraft.version", newVersion));
        }
        if (inMemoryVoters.voters().voterKeys().stream().anyMatch(voterKey -> voterKey.directoryId().isEmpty())) {
            throw new IllegalStateException(String.format("Directory id must be known for all of the voters: %s", inMemoryVoters.voters()));
        }
        if (!validateOnly) {
            boolean successful = this.kraftVersionUpgradeState.compareAndSet(inMemoryVoters, new KRaftVersionUpgrade.Version(newVersion));
            if (!successful) {
                throw new InvalidUpdateVersionException(String.format("Unable to upgrade version for %s to %s due to changing voters", "kraft.version", newVersion));
            }
            this.accumulator.appendControlMessages((baseOffset, batchEpoch, compression, buffer) -> {
                try (MemoryRecordsBuilder builder = LeaderState.createControlRecordsBuilder(baseOffset, batchEpoch, compression, buffer, currentTimeMs);){
                    this.log.info("Appended kraft.version {} to the batch accumulator", (Object)newVersion);
                    builder.appendKRaftVersionMessage(currentTimeMs, new KRaftVersionRecord().setVersion(newVersion.kraftVersionRecordVersion()).setKRaftVersion(newVersion.featureLevel()));
                    if (!inMemoryVoters.voters().equals(persistedVoters)) {
                        this.log.info("Appended voter set {} to the batch accumulator", (Object)inMemoryVoters.voters());
                        builder.appendVotersMessage(currentTimeMs, inMemoryVoters.voters().toVotersRecord(newVersion.votersRecordVersion()));
                    }
                    MemoryRecords memoryRecords = builder.build();
                    return memoryRecords;
                }
            });
        }
        return true;
    }

    private void validateEpoch(int currentEpoch) {
        if (currentEpoch < this.epoch()) {
            throw new NotLeaderException(String.format("Upgrade kraft version failed because the given epoch %s is stale. Current leader epoch is %s", currentEpoch, this.epoch()));
        }
        if (currentEpoch > this.epoch()) {
            throw new IllegalArgumentException(String.format("Attempt to append from epoch %s which is larger than the current epoch of %s", currentEpoch, this.epoch()));
        }
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    @Override
    public ElectionState election() {
        return ElectionState.withElectedLeader(this.epoch, this.localVoterNode.voterKey().id(), Optional.empty(), this.voterStates.keySet());
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public Endpoints leaderEndpoints() {
        return this.localVoterNode.listeners();
    }

    Map<Integer, ReplicaState> voterStates() {
        return this.voterStates;
    }

    Map<ReplicaKey, ReplicaState> observerStates(long currentTimeMs) {
        this.clearInactiveObservers(currentTimeMs);
        return this.observerStates;
    }

    public Set<Integer> grantingVoters() {
        return this.grantingVoters;
    }

    Set<ReplicaKey> nonAcknowledgingVoters() {
        HashSet<ReplicaKey> nonAcknowledging = new HashSet<ReplicaKey>();
        for (ReplicaState state : this.voterStates.values()) {
            if (state.hasAcknowledgedLeader) continue;
            nonAcknowledging.add(state.replicaKey);
        }
        return nonAcknowledging;
    }

    private boolean maybeUpdateHighWatermark() {
        LogOffsetMetadata highWatermarkUpdateMetadata;
        long highWatermarkUpdateOffset;
        ArrayList followersByDescendingFetchOffset = this.followersByDescendingFetchOffset().collect(Collectors.toCollection(ArrayList::new));
        int indexOfHw = this.voterStates.size() / 2;
        Optional<LogOffsetMetadata> highWatermarkUpdateOpt = ((ReplicaState)followersByDescendingFetchOffset.get((int)indexOfHw)).endOffset;
        if (highWatermarkUpdateOpt.isPresent() && (highWatermarkUpdateOffset = (highWatermarkUpdateMetadata = highWatermarkUpdateOpt.get()).offset()) > this.epochStartOffset) {
            if (this.highWatermark.isPresent()) {
                LogOffsetMetadata currentHighWatermarkMetadata = this.highWatermark.get();
                if (highWatermarkUpdateOffset > currentHighWatermarkMetadata.offset() || highWatermarkUpdateOffset == currentHighWatermarkMetadata.offset() && !highWatermarkUpdateMetadata.metadata().equals(currentHighWatermarkMetadata.metadata())) {
                    Optional<LogOffsetMetadata> oldHighWatermark = this.highWatermark;
                    this.highWatermark = highWatermarkUpdateOpt;
                    this.logHighWatermarkUpdate(oldHighWatermark, highWatermarkUpdateMetadata, indexOfHw, followersByDescendingFetchOffset);
                    return true;
                }
                if (highWatermarkUpdateOffset < currentHighWatermarkMetadata.offset()) {
                    this.log.info("The latest computed high watermark {} is smaller than the current value {}, which should only happen when voter set membership changes. If the voter set has not changed this suggests that one of the voters has lost committed data. Full voter replication state: {}", new Object[]{highWatermarkUpdateOffset, currentHighWatermarkMetadata.offset(), this.voterStates.values()});
                    return false;
                }
                return false;
            }
            Optional<LogOffsetMetadata> oldHighWatermark = this.highWatermark;
            this.highWatermark = highWatermarkUpdateOpt;
            this.logHighWatermarkUpdate(oldHighWatermark, highWatermarkUpdateMetadata, indexOfHw, followersByDescendingFetchOffset);
            return true;
        }
        return false;
    }

    private void logHighWatermarkUpdate(Optional<LogOffsetMetadata> oldHighWatermark, LogOffsetMetadata newHighWatermark, int indexOfHw, List<ReplicaState> followersByDescendingFetchOffset) {
        if (oldHighWatermark.isPresent()) {
            this.log.debug("High watermark set to {} from {} based on indexOfHw {} and voters {}", new Object[]{newHighWatermark, oldHighWatermark.get(), indexOfHw, followersByDescendingFetchOffset});
        } else {
            this.log.info("High watermark set to {} for the first time for epoch {} based on indexOfHw {} and voters {}", new Object[]{newHighWatermark, this.epoch, indexOfHw, followersByDescendingFetchOffset});
        }
    }

    public boolean updateLocalState(LogOffsetMetadata endOffsetMetadata, VoterSet lastVoterSet) {
        ReplicaState state = this.getOrCreateReplicaState(this.localVoterNode.voterKey());
        state.endOffset.ifPresent(currentEndOffset -> {
            if (currentEndOffset.offset() > endOffsetMetadata.offset()) {
                throw new IllegalStateException("Detected non-monotonic update of local end offset: " + currentEndOffset.offset() + " -> " + endOffsetMetadata.offset());
            }
        });
        state.updateLeaderEndOffset(endOffsetMetadata);
        this.updateVoterAndObserverStates(lastVoterSet);
        return this.maybeUpdateHighWatermark();
    }

    public boolean updateReplicaState(ReplicaKey replicaKey, long currentTimeMs, LogOffsetMetadata fetchOffsetMetadata) {
        if (replicaKey.id() < 0) {
            return false;
        }
        if (replicaKey.id() == this.localVoterNode.voterKey().id()) {
            throw new IllegalStateException(String.format("Remote replica ID %s matches the local leader ID", replicaKey));
        }
        ReplicaState state = this.getOrCreateReplicaState(replicaKey);
        state.endOffset.ifPresent(currentEndOffset -> {
            if (currentEndOffset.offset() > fetchOffsetMetadata.offset()) {
                this.log.warn("Detected non-monotonic update of fetch offset from nodeId {}: {} -> {}", new Object[]{state.replicaKey, currentEndOffset.offset(), fetchOffsetMetadata.offset()});
            }
        });
        Optional<LogOffsetMetadata> leaderEndOffsetOpt = this.getOrCreateReplicaState((ReplicaKey)this.localVoterNode.voterKey()).endOffset;
        state.updateFollowerState(currentTimeMs, fetchOffsetMetadata, leaderEndOffsetOpt);
        this.updateCheckQuorumForFollowingVoter(replicaKey, currentTimeMs);
        return this.isVoter(state.replicaKey) && this.maybeUpdateHighWatermark();
    }

    public List<ReplicaKey> nonLeaderVotersByDescendingFetchOffset() {
        return this.followersByDescendingFetchOffset().filter(state -> !state.matchesKey(this.localVoterNode.voterKey())).map(state -> state.replicaKey).collect(Collectors.toList());
    }

    Map<Integer, OptionalLong> voterToFetchOffsetMap() {
        return this.voterStates.values().stream().collect(Collectors.toMap(r -> r.replicaKey.id(), r -> r.endOffset.map(logOffsetMetadata -> OptionalLong.of(logOffsetMetadata.offset())).orElseGet(OptionalLong::empty)));
    }

    private Stream<ReplicaState> followersByDescendingFetchOffset() {
        return this.voterStates.values().stream().sorted();
    }

    public void addAcknowledgementFrom(int remoteNodeId) {
        ReplicaState voterState = this.ensureValidVoter(remoteNodeId);
        voterState.hasAcknowledgedLeader = true;
    }

    private ReplicaState ensureValidVoter(int remoteNodeId) {
        ReplicaState state = this.voterStates.get(remoteNodeId);
        if (state == null) {
            throw new IllegalArgumentException("Unexpected acknowledgement from non-voter " + remoteNodeId);
        }
        return state;
    }

    public long epochStartOffset() {
        return this.epochStartOffset;
    }

    private ReplicaState getOrCreateReplicaState(ReplicaKey replicaKey) {
        ReplicaState state = this.voterStates.get(replicaKey.id());
        if (state == null || !state.matchesKey(replicaKey)) {
            this.observerStates.putIfAbsent(replicaKey, new ReplicaState(replicaKey, false, Endpoints.empty()));
            this.kafkaRaftMetrics.updateNumObservers(this.observerStates.size());
            return this.observerStates.get(replicaKey);
        }
        return state;
    }

    public Optional<ReplicaState> getReplicaState(ReplicaKey replicaKey) {
        ReplicaState state = this.voterStates.get(replicaKey.id());
        if (state == null || !state.matchesKey(replicaKey)) {
            state = this.observerStates.get(replicaKey);
        }
        return Optional.ofNullable(state);
    }

    private void clearInactiveObservers(long currentTimeMs) {
        this.observerStates.entrySet().removeIf(integerReplicaStateEntry -> currentTimeMs - ((ReplicaState)integerReplicaStateEntry.getValue()).lastFetchTimestamp >= 300000L && !((ReplicaKey)integerReplicaStateEntry.getKey()).equals(this.localVoterNode.voterKey()));
        this.kafkaRaftMetrics.updateNumObservers(this.observerStates.size());
    }

    private boolean isVoter(ReplicaKey remoteReplicaKey) {
        ReplicaState state = this.voterStates.get(remoteReplicaKey.id());
        return state != null && state.matchesKey(remoteReplicaKey);
    }

    private void updateVoterAndObserverStates(VoterSet lastVoterSet) {
        HashMap<Integer, ReplicaState> newVoterStates = new HashMap<Integer, ReplicaState>();
        HashMap<Integer, ReplicaState> oldVoterStates = new HashMap<Integer, ReplicaState>(this.voterStates);
        for (VoterSet.VoterNode voterNode : lastVoterSet.voterNodes()) {
            ReplicaState state = this.getReplicaState(voterNode.voterKey()).orElse(new ReplicaState(voterNode.voterKey(), false, voterNode.listeners()));
            oldVoterStates.remove(voterNode.voterKey().id());
            this.observerStates.remove(voterNode.voterKey());
            state.setReplicaKey(voterNode.voterKey());
            state.updateListeners(voterNode.listeners());
            newVoterStates.put(state.replicaKey.id(), state);
        }
        this.voterStates = newVoterStates;
        for (ReplicaState replicaStateEntry : oldVoterStates.values()) {
            replicaStateEntry.clearListeners();
            this.observerStates.putIfAbsent(replicaStateEntry.replicaKey, replicaStateEntry);
        }
        this.kafkaRaftMetrics.updateNumObservers(this.observerStates.size());
    }

    @Override
    public boolean canGrantVote(ReplicaKey replicaKey, boolean isLogUpToDate, boolean isPreVote) {
        this.log.debug("Rejecting Vote request (preVote={}) from replica ({}) since we are already leader in epoch {}", new Object[]{isPreVote, replicaKey, this.epoch});
        return false;
    }

    public String toString() {
        return String.format("Leader(localVoterNode=%s, epoch=%d, epochStartOffset=%d, highWatermark=%s, voterStates=%s)", this.localVoterNode, this.epoch, this.epochStartOffset, this.highWatermark, this.voterStates);
    }

    @Override
    public String name() {
        return "Leader";
    }

    @Override
    public void close() {
        this.resetAddVoterHandlerState(Errors.NOT_LEADER_OR_FOLLOWER, null, Optional.empty());
        this.resetRemoveVoterHandlerState(Errors.NOT_LEADER_OR_FOLLOWER, null, Optional.empty());
        this.kafkaRaftMetrics.removeLeaderMetrics();
        this.accumulator.close();
    }

    public static class ReplicaState
    implements Comparable<ReplicaState> {
        private ReplicaKey replicaKey;
        private Endpoints listeners;
        private Optional<LogOffsetMetadata> endOffset;
        private long lastFetchTimestamp;
        private long lastFetchLeaderLogEndOffset;
        private long lastCaughtUpTimestamp;
        private boolean hasAcknowledgedLeader;

        public ReplicaState(ReplicaKey replicaKey, boolean hasAcknowledgedLeader, Endpoints listeners) {
            this.replicaKey = replicaKey;
            this.listeners = listeners;
            this.endOffset = Optional.empty();
            this.lastFetchTimestamp = -1L;
            this.lastFetchLeaderLogEndOffset = -1L;
            this.lastCaughtUpTimestamp = -1L;
            this.hasAcknowledgedLeader = hasAcknowledgedLeader;
        }

        public ReplicaKey replicaKey() {
            return this.replicaKey;
        }

        public Endpoints listeners() {
            return this.listeners;
        }

        public Optional<LogOffsetMetadata> endOffset() {
            return this.endOffset;
        }

        public long lastFetchTimestamp() {
            return this.lastFetchTimestamp;
        }

        public long lastCaughtUpTimestamp() {
            return this.lastCaughtUpTimestamp;
        }

        void setReplicaKey(ReplicaKey replicaKey) {
            if (this.replicaKey.id() != replicaKey.id()) {
                throw new IllegalArgumentException(String.format("Attempting to update the replica key %s with a different replica id %s", this.replicaKey, replicaKey));
            }
            if (this.replicaKey.directoryId().isPresent() && !this.replicaKey.equals(replicaKey)) {
                throw new IllegalArgumentException(String.format("Attempting to update an already set directory id %s with a different directory id %s", this.replicaKey, replicaKey));
            }
            this.replicaKey = replicaKey;
        }

        void updateListeners(Endpoints listeners) {
            this.listeners = listeners;
        }

        void clearListeners() {
            this.updateListeners(Endpoints.empty());
        }

        boolean matchesKey(ReplicaKey replicaKey) {
            if (this.replicaKey.id() != replicaKey.id()) {
                return false;
            }
            if (this.replicaKey.directoryId().isPresent()) {
                return this.replicaKey.directoryId().equals(replicaKey.directoryId());
            }
            return true;
        }

        void updateLeaderEndOffset(LogOffsetMetadata endOffsetMetadata) {
            this.endOffset = Optional.of(endOffsetMetadata);
        }

        void updateFollowerState(long currentTimeMs, LogOffsetMetadata fetchOffsetMetadata, Optional<LogOffsetMetadata> leaderEndOffsetOpt) {
            leaderEndOffsetOpt.ifPresent(leaderEndOffset -> {
                if (fetchOffsetMetadata.offset() >= leaderEndOffset.offset()) {
                    this.lastCaughtUpTimestamp = Math.max(this.lastCaughtUpTimestamp, currentTimeMs);
                } else if (this.lastFetchLeaderLogEndOffset > 0L && fetchOffsetMetadata.offset() >= this.lastFetchLeaderLogEndOffset) {
                    this.lastCaughtUpTimestamp = Math.max(this.lastCaughtUpTimestamp, this.lastFetchTimestamp);
                }
                this.lastFetchLeaderLogEndOffset = leaderEndOffset.offset();
            });
            this.lastFetchTimestamp = Math.max(this.lastFetchTimestamp, currentTimeMs);
            this.endOffset = Optional.of(fetchOffsetMetadata);
            this.hasAcknowledgedLeader = true;
        }

        @Override
        public int compareTo(ReplicaState that) {
            if (this.endOffset.equals(that.endOffset)) {
                return this.replicaKey.compareTo(that.replicaKey);
            }
            if (this.endOffset.isEmpty()) {
                return 1;
            }
            if (that.endOffset.isEmpty()) {
                return -1;
            }
            return Long.compare(that.endOffset.get().offset(), this.endOffset.get().offset());
        }

        public String toString() {
            return String.format("ReplicaState(replicaKey=%s, endOffset=%s, lastFetchTimestamp=%s, lastCaughtUpTimestamp=%s, hasAcknowledgedLeader=%s)", this.replicaKey, this.endOffset, this.lastFetchTimestamp, this.lastCaughtUpTimestamp, this.hasAcknowledgedLeader);
        }
    }
}

