/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.embedded;

import io.confluent.ksql.embedded.KsqlContext;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Collections;

public final class EmbeddedKsql {
    private EmbeddedKsql() {
    }

    public static void main(String[] args) {
        KsqlContext ksqlContext = KsqlContext.create((KsqlConfig)new KsqlConfig(Collections.emptyMap()), (ProcessingLogContext)ProcessingLogContext.create(), (MetricCollectors)new MetricCollectors());
        ksqlContext.sql("REGISTER TOPIC orders_topic WITH (format = 'json', kafka_topic='orders_topic_json');");
        ksqlContext.sql("CREATE STREAM orders (orderid bigint KEY, ordertime bigint, itemid varchar, orderunits double, arraycol array<double>, mapcol map<varchar, double>) WITH (topicname = 'orders_topic' );\n");
        ksqlContext.sql("CREATE STREAM BIGORDERS AS SELECT * FROM ORDERS WHERE ORDERUNITS > 5;");
        ksqlContext.sql("SELECT * FROM ORDERS;");
        ksqlContext.sql("CREATE TABLE ORDERSUMS AS select itemid, sum(orderunits) from orders window TUMBLING ( size 30 second) group by itemid;");
        System.out.println("Queries are running!");
    }
}

