/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.cli.console.JLineReader;
import io.confluent.ksql.cli.console.KsqlTerminal;
import io.confluent.ksql.cli.console.writer.MultiplexedWriter;
import io.confluent.ksql.util.KsqlException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.concurrent.NotThreadSafe;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStyle;
import org.jline.utils.InfoCmp;
import org.jline.utils.Status;

@NotThreadSafe
class JLineTerminal
implements KsqlTerminal {
    private static final AttributedString DEFAULT_STATUS_MSG = new AttributedString((CharSequence)"", AttributedStyle.DEFAULT);
    private final Terminal terminal;
    private final JLineReader lineReader;
    private final Function<Terminal, Status> statusFactory;
    private Optional<Spool> spool = Optional.empty();

    JLineTerminal(Predicate<String> cliLinePredicate, Path historyFilePath) {
        this(cliLinePredicate, historyFilePath, Status::getStatus);
    }

    JLineTerminal(Predicate<String> cliLinePredicate, Path historyFilePath, Function<Terminal, Status> statusFactory) {
        this.terminal = JLineTerminal.buildTerminal();
        this.lineReader = new JLineReader(this.terminal, historyFilePath, cliLinePredicate);
        this.statusFactory = Objects.requireNonNull(statusFactory, "statusFactory");
    }

    JLineTerminal(Terminal terminal, JLineReader lineReader, Function<Terminal, Status> statusFactory) {
        this.terminal = terminal;
        this.lineReader = lineReader;
        this.statusFactory = Objects.requireNonNull(statusFactory, "statusFactory");
    }

    @Override
    public PrintWriter writer() {
        return this.spool.map(Spool::getMultiplexed).orElse(this.terminal.writer());
    }

    @Override
    public void flush() {
        this.spool.map(Spool::getSpool).ifPresent(PrintWriter::flush);
        this.terminal.flush();
    }

    @Override
    public int getWidth() {
        return this.terminal.getWidth();
    }

    @Override
    public void close() {
        try {
            this.unsetSpool();
            this.terminal.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public String readLine() {
        String line = this.lineReader.readLine();
        this.spool.map(Spool::getSpool).ifPresent(writer -> writer.write("\nksql> " + line + "\n"));
        return line;
    }

    @Override
    public void clearScreen() {
        this.terminal.puts(InfoCmp.Capability.clear_screen, new Object[0]);
    }

    @Override
    public void handle(Terminal.Signal signal, Terminal.SignalHandler signalHandler) {
        this.terminal.handle(signal, signalHandler);
    }

    @Override
    public void setSpool(Writer writer) {
        this.spool.ifPresent(ignored -> {
            throw new KsqlException("Cannot set two spools! Please issue SPOOL OFF.");
        });
        this.spool = Optional.of(new Spool(writer, this.terminal.writer()));
    }

    @Override
    public void unsetSpool() {
        this.spool.map(Spool::getSpool).ifPresent(PrintWriter::close);
        this.spool = Optional.empty();
    }

    @Override
    public List<KsqlTerminal.HistoryEntry> getHistory() {
        ArrayList<KsqlTerminal.HistoryEntry> history = new ArrayList<KsqlTerminal.HistoryEntry>();
        this.lineReader.getHistory().forEach(entry -> history.add(KsqlTerminal.HistoryEntry.of(entry.index() + 1, entry.line())));
        return history;
    }

    @Override
    public KsqlTerminal.StatusClosable setStatusMessage(String message) {
        this.updateStatusBar(new AttributedString((CharSequence)message, AttributedStyle.INVERSE));
        return () -> this.updateStatusBar(DEFAULT_STATUS_MSG);
    }

    @Override
    public void printError(String message) {
        this.writer().println(new AttributedString((CharSequence)message, AttributedStyle.DEFAULT.foreground(1)).toAnsi());
    }

    @VisibleForTesting
    Terminal getTerminal() {
        return this.terminal;
    }

    private void updateStatusBar(AttributedString message) {
        Status statusBar = this.statusFactory.apply(this.terminal);
        statusBar.update(Collections.singletonList(message));
    }

    private static Terminal buildTerminal() {
        try {
            Terminal terminal = TerminalBuilder.builder().system(true).build();
            terminal.handle(Terminal.Signal.INT, Terminal.SignalHandler.SIG_IGN);
            return terminal;
        }
        catch (IOException e) {
            throw new RuntimeException("JLineTerminal failed to start!", e);
        }
    }

    private static final class Spool {
        final PrintWriter spool;
        final PrintWriter multiplexed;

        private Spool(Writer spool, PrintWriter original) {
            Objects.requireNonNull(original, "original");
            this.spool = new PrintWriter(Objects.requireNonNull(spool, "spool"));
            this.multiplexed = new PrintWriter(new MultiplexedWriter(spool, original));
        }

        PrintWriter getSpool() {
            return this.spool;
        }

        PrintWriter getMultiplexed() {
            return this.multiplexed;
        }
    }
}

