/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum OutputFormat {
    JSON,
    TABULAR;

    public static final String VALID_FORMATS;

    public static OutputFormat get(String format) {
        try {
            return OutputFormat.valueOf(format);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unknown Output format: " + format + ". Valid values are: " + VALID_FORMATS);
        }
    }

    static {
        VALID_FORMATS = Arrays.stream(OutputFormat.values()).map(Object::toString).collect(Collectors.joining("', '", "'", "'"));
    }
}

