/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console;

import java.util.Objects;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;

final class TrimmingParser
implements Parser {
    private final Parser delegate;

    TrimmingParser(Parser delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        String trimmed = line.trim();
        int adjCursor = TrimmingParser.adjustCursor(line, trimmed, cursor);
        return this.delegate.parse(trimmed, adjCursor, context);
    }

    private static int adjustCursor(String origLine, String trimmedLine, int origCursor) {
        int prefixLen = origLine.indexOf(trimmedLine);
        if (origCursor < prefixLen) {
            return 0;
        }
        if (origCursor < prefixLen + trimmedLine.length()) {
            return origCursor - prefixLen;
        }
        return trimmedLine.length();
    }
}

