/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.cmd;

import io.confluent.ksql.cli.console.KsqlTerminal;
import io.confluent.ksql.cli.console.cmd.CliCmdUtil;
import io.confluent.ksql.cli.console.cmd.CliSpecificCommand;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

final class History
implements CliSpecificCommand {
    private static final String HELP = "history:" + System.lineSeparator() + "\tShow previous lines entered during the current CLI session. You can use up and down arrow keys to view previous lines.";
    private final Supplier<? extends Collection<KsqlTerminal.HistoryEntry>> historySupplier;

    private History(Supplier<? extends Collection<KsqlTerminal.HistoryEntry>> historySupplier) {
        this.historySupplier = Objects.requireNonNull(historySupplier, "historySupplier");
    }

    static History create(Supplier<? extends Collection<KsqlTerminal.HistoryEntry>> historySupplier) {
        return new History(historySupplier);
    }

    @Override
    public String getName() {
        return "history";
    }

    @Override
    public String getHelpMessage() {
        return HELP;
    }

    @Override
    public void execute(List<String> args, PrintWriter terminal) {
        CliCmdUtil.ensureArgCountBounds(args, 0, 0, HELP);
        this.historySupplier.get().forEach(historyEntry -> terminal.printf("%4d: %s%n", historyEntry.getIndex(), historyEntry.getLine()));
    }
}

