/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.cmd;

import io.confluent.ksql.cli.KsqlRequestExecutor;
import io.confluent.ksql.cli.console.cmd.CliCmdUtil;
import io.confluent.ksql.cli.console.cmd.CliSpecificCommand;
import io.confluent.ksql.util.KsqlException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class RunScript
implements CliSpecificCommand {
    private static final String HELP = "run script <path_to_sql_file>:" + System.lineSeparator() + "\tLoad and run the statements in the supplied file." + System.lineSeparator() + "\tNote: the file must be UTF-8 encoded.";
    private final KsqlRequestExecutor requestExecutor;

    private RunScript(KsqlRequestExecutor requestExecutor) {
        this.requestExecutor = Objects.requireNonNull(requestExecutor, "requestExecutor");
    }

    public static RunScript create(KsqlRequestExecutor requestExecutor) {
        return new RunScript(requestExecutor);
    }

    @Override
    public String getName() {
        return "run script";
    }

    @Override
    public String getHelpMessage() {
        return HELP;
    }

    @Override
    public void execute(List<String> args, PrintWriter terminal) {
        CliCmdUtil.ensureArgCountBounds(args, 1, 1, HELP);
        String filePath = args.get(0);
        String content = RunScript.loadScript(filePath);
        this.requestExecutor.makeKsqlRequest(content);
    }

    private static String loadScript(String filePath) {
        try {
            return Files.readAllLines(Paths.get(filePath, new String[0]), StandardCharsets.UTF_8).stream().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new KsqlException("Failed to read file: " + filePath, (Throwable)e);
        }
    }
}

