/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.cmd;

import io.confluent.ksql.cli.console.cmd.CliCmdUtil;
import io.confluent.ksql.cli.console.cmd.CliSpecificCommand;
import java.io.PrintWriter;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

final class Version
implements CliSpecificCommand {
    private static final String HELP = "version:" + System.lineSeparator() + "\tGet the current KSQL version.";
    private final Supplier<String> versionSupplier;

    private Version(Supplier<String> versionSupplier) {
        this.versionSupplier = Objects.requireNonNull(versionSupplier, "versionSupplier");
    }

    static Version create(Supplier<String> versionSupplier) {
        return new Version(versionSupplier);
    }

    @Override
    public String getName() {
        return "version";
    }

    @Override
    public String getHelpMessage() {
        return HELP;
    }

    @Override
    public void execute(List<String> args, PrintWriter terminal) {
        CliCmdUtil.ensureArgCountBounds(args, 0, 0, HELP);
        String version = this.versionSupplier.get();
        terminal.printf("Version: %s%n", version);
    }
}

