/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.table;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.cli.console.Console;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class Table {
    private final ImmutableList<String> columnHeaders;
    private final ImmutableList<List<String>> rowValues;
    private final ImmutableList<String> header;
    private final ImmutableList<String> footer;

    private Table(List<String> columnHeaders, List<List<String>> rowValues, List<String> header, List<String> footer) {
        this.columnHeaders = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnHeaders, "columnHeaders"));
        this.rowValues = ImmutableList.copyOf((Collection)Objects.requireNonNull(rowValues, "rowValues"));
        this.header = ImmutableList.copyOf((Collection)Objects.requireNonNull(header, "header"));
        this.footer = ImmutableList.copyOf((Collection)Objects.requireNonNull(footer, "footer"));
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="columnHeaders is ImmutableList")
    public List<String> headers() {
        return this.columnHeaders;
    }

    @VisibleForTesting
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="rowValues is ImmutableList")
    public List<List<String>> rows() {
        return this.rowValues;
    }

    private int getMultiLineStringLength(String multiLineString) {
        String[] split = multiLineString.split(System.lineSeparator());
        return Arrays.stream(split).mapToInt(String::length).max().orElse(0);
    }

    private int getColumnLength(List<String> columnHeaders, List<List<String>> rowValues, int i) {
        return Math.max(columnHeaders.get(i).length(), rowValues.stream().mapToInt(r -> this.getMultiLineStringLength((String)r.get(i))).max().orElse(0));
    }

    public void print(Console console) {
        this.header.forEach(m -> console.writer().println((String)m));
        if (this.columnHeaders.size() > 0) {
            console.addResult((List<List<String>>)this.rowValues);
            Integer[] columnLengths = new Integer[this.columnHeaders.size()];
            int separatorLength = -1;
            for (int i = 0; i < columnLengths.length; ++i) {
                int columnLength = this.getColumnLength((List<String>)this.columnHeaders, (List<List<String>>)this.rowValues, i);
                columnLengths[i] = columnLength;
                separatorLength += columnLength + 3;
            }
            String rowFormatString = Table.constructRowFormatString(columnLengths);
            console.writer().printf(rowFormatString, this.columnHeaders.toArray());
            String separator = StringUtils.repeat((char)'-', (int)Math.min(console.getWidth(), separatorLength));
            console.writer().println(separator);
            for (List row : this.rowValues) {
                console.writer().printf(rowFormatString, row.toArray());
            }
            console.writer().println(separator);
        }
        this.footer.forEach(m -> console.writer().println((String)m));
        console.flush();
    }

    private static String constructRowFormatString(Integer ... lengths) {
        List columnFormatStrings = Arrays.stream(lengths).map(Table::constructSingleColumnFormatString).collect(Collectors.toList());
        return String.format(" %s %n", String.join((CharSequence)" | ", columnFormatStrings));
    }

    private static String constructSingleColumnFormatString(Integer length) {
        return String.format("%%%ds", -1 * length);
    }

    public static final class Builder {
        private final List<String> columnHeaders = new LinkedList<String>();
        private final List<List<String>> rowValues = new LinkedList<List<String>>();
        private final List<String> header = new LinkedList<String>();
        private final List<String> footer = new LinkedList<String>();

        public Table build() {
            return new Table(this.columnHeaders, this.rowValues, this.header, this.footer);
        }

        public Builder withColumnHeaders(List<String> columnHeaders) {
            this.columnHeaders.addAll(columnHeaders);
            return this;
        }

        public Builder withColumnHeaders(String ... columnHeaders) {
            this.columnHeaders.addAll(Arrays.asList(columnHeaders));
            return this;
        }

        public Builder withRows(List<List<String>> rowValues) {
            this.rowValues.addAll(rowValues);
            return this;
        }

        public Builder withRows(Stream<List<String>> rowValues) {
            rowValues.forEach(this.rowValues::add);
            return this;
        }

        public Builder withRow(String ... row) {
            this.rowValues.add(Arrays.asList(row));
            return this;
        }

        public Builder withRow(List<String> row) {
            this.rowValues.add(row);
            return this;
        }

        public Builder withHeaderLine(String headerLine) {
            this.header.add(headerLine);
            return this;
        }

        public Builder withFooterLine(String footerLine) {
            this.footer.add(footerLine);
            return this;
        }
    }
}

