/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.table.builder;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.cli.console.table.Table;
import io.confluent.ksql.cli.console.table.builder.TableBuilder;
import io.confluent.ksql.rest.entity.SourceInfo;
import io.confluent.ksql.rest.entity.TablesList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public class TablesListTableBuilder
implements TableBuilder<TablesList> {
    private static final List<String> HEADERS = ImmutableList.of((Object)"Table Name", (Object)"Kafka Topic", (Object)"Key Format", (Object)"Value Format", (Object)"Windowed");

    @Override
    public Table buildTable(TablesList entity) {
        Stream<List<String>> rows = entity.getTables().stream().sorted(Comparator.comparing(SourceInfo::getName)).map(t -> ImmutableList.of((Object)t.getName(), (Object)t.getTopic(), (Object)t.getKeyFormat(), (Object)t.getValueFormat(), (Object)Boolean.toString(t.isWindowed())));
        return new Table.Builder().withColumnHeaders(HEADERS).withRows(rows).build();
    }
}

