/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.cli.console.writer;

import java.io.IOException;
import java.io.Writer;
import java.util.Objects;

public class MultiplexedWriter
extends Writer {
    private final Writer[] writers;

    public MultiplexedWriter(Writer ... writers) {
        this.writers = Objects.requireNonNull(writers, "writers");
    }

    @Override
    public void write(char[] chars, int off, int len) throws IOException {
        for (Writer writer : this.writers) {
            writer.write(chars, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (Writer writer : this.writers) {
            writer.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (Writer writer : this.writers) {
            writer.close();
        }
    }
}

