/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import com.google.common.collect.ImmutableList;
import java.util.List;

public final class CmdLineUtil {
    private CmdLineUtil() {
    }

    public static List<String> splitByUnquotedWhitespace(String string) {
        return new WhitespaceParser().parse(string);
    }

    public static String removeMatchedSingleQuotes(String string) {
        return new QuoteRemover().parse(string);
    }

    private static boolean isLineComment(char prevChar, char current) {
        return prevChar == '-' && current == '-';
    }

    private static boolean isEscapedChar(String input, int pos) {
        return input.length() >= pos + 2 && input.charAt(pos + 1) == '\'';
    }

    private static final class WhitespaceParser {
        private boolean inQuotes;
        private boolean inWhitespace;
        private boolean inComment;
        private char prevChar;
        private String input;
        private ImmutableList.Builder<String> output;
        private final StringBuilder currentToken = new StringBuilder();

        private WhitespaceParser() {
        }

        private List<String> parse(String s) {
            this.inQuotes = false;
            this.inWhitespace = false;
            this.inComment = false;
            this.prevChar = '\u0000';
            this.input = s.trim();
            this.currentToken.setLength(0);
            this.output = ImmutableList.builder();
            for (int pos = 0; pos != this.input.length(); ++pos) {
                pos = this.processCharAt(pos);
            }
            String remainder = this.currentToken.toString();
            if (!remainder.isEmpty()) {
                this.output.add((Object)remainder);
            }
            return this.output.build();
        }

        private int processCharAt(int pos) {
            char c = this.input.charAt(pos);
            int returnPos = pos;
            if (!Character.isWhitespace(c)) {
                this.inWhitespace = false;
            } else if (!(this.inQuotes || this.inWhitespace || this.inComment && c != '\n')) {
                this.inWhitespace = true;
                this.inComment = false;
                this.output.add((Object)this.currentToken.toString());
                this.currentToken.setLength(0);
            }
            if (!this.inWhitespace) {
                this.currentToken.append(c);
            }
            if (CmdLineUtil.isLineComment(this.prevChar, c)) {
                this.inComment = true;
            }
            if (c == '\'' && !this.inComment) {
                if (!this.inQuotes) {
                    this.inQuotes = true;
                } else if (CmdLineUtil.isEscapedChar(this.input, pos)) {
                    this.currentToken.append('\'');
                    ++returnPos;
                } else {
                    this.inQuotes = false;
                }
            }
            this.prevChar = c;
            return returnPos;
        }
    }

    private static final class QuoteRemover {
        private static final int NOT_SET = -1;
        private int quoteStart;
        private int unquotedStart;
        private String input;
        private String result;

        private QuoteRemover() {
        }

        private String parse(String s) {
            this.quoteStart = -1;
            this.unquotedStart = -1;
            this.input = s;
            this.result = "";
            for (int pos = 0; pos != this.input.length(); ++pos) {
                pos = this.processCharAt(pos);
            }
            if (this.quoteStart != -1) {
                this.result = this.result + this.input.substring(this.quoteStart);
            } else if (this.unquotedStart != -1) {
                this.result = this.result + this.input.substring(this.unquotedStart);
            }
            return this.result;
        }

        private int processCharAt(int pos) {
            char c = this.input.charAt(pos);
            int returnPos = pos;
            if (c == '\'') {
                if (this.quoteStart == -1) {
                    if (this.unquotedStart != -1) {
                        this.appendResult(this.unquotedStart, pos);
                        this.unquotedStart = -1;
                    }
                    this.quoteStart = pos;
                } else if (CmdLineUtil.isEscapedChar(this.input, pos)) {
                    ++returnPos;
                } else {
                    this.appendResult(this.quoteStart + 1, pos);
                    this.quoteStart = -1;
                }
            } else if (this.quoteStart == -1 && this.unquotedStart == -1) {
                this.unquotedStart = pos;
            }
            return returnPos;
        }

        private void appendResult(int start, int end) {
            this.result = this.result + this.input.substring(start, end).replaceAll("''", "'");
        }
    }
}

