/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.NoOpTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;

@Plugin(name="TimestampLogFileAppender", category="Core", elementType="appender", printObject=true)
public class TimestampLogFileAppender
extends AbstractAppender {
    private static RollingFileAppender rollingFileAppender;

    protected TimestampLogFileAppender(String name, Layout<?> layout, Filter filter, boolean ignoreExceptions, RollingFileAppender rollingFileAppender) {
        super(name, filter, layout, ignoreExceptions);
    }

    @PluginFactory
    public static TimestampLogFileAppender createAppender(@PluginAttribute(value="name") @Required String name, @PluginAttribute(value="fileName") String fileName, @PluginElement(value="Layout") Layout<?> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="filePattern") String filePattern, @PluginAttribute(value="ImmediateFlush") boolean immediateFlush, @PluginAttribute(value="ignoreExceptions") boolean ignoreExceptions) {
        String updatedFileName = fileName;
        if (updatedFileName.contains("%timestamp")) {
            Date d = new Date();
            SimpleDateFormat format = new SimpleDateFormat("yyMMdd-HHmmss");
            updatedFileName = updatedFileName.replaceAll("%timestamp", format.format(d));
        }
        rollingFileAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().withFileName(updatedFileName).withName(name)).withFilePattern(filePattern).withIgnoreExceptions(ignoreExceptions)).withBufferedIo(true)).withBufferSize(8192)).withLayout(layout)).withFilter(filter)).withImmediateFlush(immediateFlush)).withPolicy((TriggeringPolicy)new NoOpTriggeringPolicy()).build();
        return new TimestampLogFileAppender(name, layout, filter, ignoreExceptions, rollingFileAppender);
    }

    public void append(LogEvent event) {
        rollingFileAppender.append(event);
    }
}

