/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.util;

public final class Identifiers {
    private Identifiers() {
    }

    public static String getIdentifierText(String text) {
        if (text.isEmpty()) {
            return "";
        }
        char firstChar = text.charAt(0);
        if (firstChar == '`' || firstChar == '\"') {
            return Identifiers.validateAndUnquote(text, firstChar);
        }
        return text.toUpperCase();
    }

    private static String validateAndUnquote(String value, char quote) {
        if (value.charAt(0) != quote) {
            throw new IllegalStateException("Value must begin with quote");
        }
        if (value.charAt(value.length() - 1) != quote || value.length() < 2) {
            throw new IllegalArgumentException("Expected matching quote at end of value");
        }
        int i = 1;
        while (i < value.length() - 1) {
            if (value.charAt(i) == quote) {
                if (value.charAt(i + 1) != quote || i + 1 == value.length() - 1) {
                    throw new IllegalArgumentException("Un-escaped quote in middle of value at index " + i);
                }
                i += 2;
                continue;
            }
            ++i;
        }
        return value.substring(1, value.length() - 1).replace("" + quote + quote, "" + quote);
    }
}

