/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.auth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.auth.ApiUser;
import io.confluent.ksql.api.auth.AuthenticationPlugin;
import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.security.DefaultKsqlPrincipal;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.security.Principal;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class AuthenticationPluginHandler
implements Handler<RoutingContext> {
    private final Server server;
    private final AuthenticationPlugin securityHandlerPlugin;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public AuthenticationPluginHandler(Server server, AuthenticationPlugin securityHandlerPlugin) {
        this.server = Objects.requireNonNull(server);
        this.securityHandlerPlugin = Objects.requireNonNull(securityHandlerPlugin);
    }

    public void handle(RoutingContext routingContext) {
        CompletableFuture<Principal> cf = this.securityHandlerPlugin.handleAuth(routingContext, this.server.getWorkerExecutor());
        ((CompletableFuture)cf.thenAccept(principal -> {
            if (principal == null) {
                routingContext.fail(HttpResponseStatus.UNAUTHORIZED.code(), (Throwable)((Object)new KsqlApiException("Failed authentication", Errors.ERROR_CODE_UNAUTHORIZED)));
            } else {
                routingContext.setUser((User)new AuthPluginUser((Principal)principal));
                routingContext.next();
            }
        })).exceptionally(t -> {
            if (!routingContext.failed()) {
                routingContext.fail(t);
            }
            return null;
        });
    }

    private static class AuthPluginUser
    implements ApiUser {
        private final DefaultKsqlPrincipal principal;

        AuthPluginUser(Principal principal) {
            Objects.requireNonNull(principal);
            this.principal = new DefaultKsqlPrincipal(principal);
        }

        public JsonObject attributes() {
            throw new UnsupportedOperationException();
        }

        public User isAuthorized(Authorization authority, Handler<AsyncResult<Boolean>> resultHandler) {
            throw new UnsupportedOperationException();
        }

        public User isAuthorized(String s, Handler<AsyncResult<Boolean>> handler) {
            throw new UnsupportedOperationException();
        }

        public User clearCache() {
            throw new UnsupportedOperationException();
        }

        public JsonObject principal() {
            throw new UnsupportedOperationException();
        }

        public void setAuthProvider(AuthProvider authProvider) {
            throw new UnsupportedOperationException();
        }

        public User merge(User other) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DefaultKsqlPrincipal getPrincipal() {
            return this.principal;
        }
    }
}

