/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.auth;

import io.confluent.ksql.security.DefaultKsqlPrincipal;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class JaasPrincipal
extends DefaultKsqlPrincipal {
    private final String name;
    private final String password;
    private final String token;

    public JaasPrincipal(String name, String password) {
        this(name, password, "", 0);
    }

    private JaasPrincipal(String name, String password, String ipAddress, int port) {
        super((Principal)new BasicJaasPrincipal(name), ipAddress, port);
        this.name = Objects.requireNonNull(name, "name");
        this.password = Objects.requireNonNull(password, "password");
        this.token = JaasPrincipal.createToken(name, password);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getUserProperties() {
        return Collections.emptyMap();
    }

    public String getToken() {
        return this.token;
    }

    public DefaultKsqlPrincipal withIpAddressAndPort(String ipAddress, int port) {
        return new JaasPrincipal(this.name, this.password, ipAddress, port);
    }

    private static String createToken(String name, String secret) {
        return Base64.getEncoder().encodeToString((name + ":" + secret).getBytes(StandardCharsets.ISO_8859_1));
    }

    static class BasicJaasPrincipal
    implements Principal {
        private final String name;

        BasicJaasPrincipal(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

