/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.ksql.api.auth.ApiSecurityContext;
import io.confluent.ksql.api.impl.KsqlSecurityContextProvider;
import io.confluent.ksql.rest.client.KsqlClient;
import io.confluent.ksql.rest.server.services.RestServiceContextFactory;
import io.confluent.ksql.security.KsqlPrincipal;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.security.KsqlSecurityExtension;
import io.confluent.ksql.services.ConnectClientFactory;
import io.confluent.ksql.util.KsqlConfig;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.streams.KafkaClientSupplier;

public class DefaultKsqlSecurityContextProvider
implements KsqlSecurityContextProvider {
    private final KsqlSecurityExtension securityExtension;
    private final RestServiceContextFactory.DefaultServiceContextFactory defaultServiceContextFactory;
    private final RestServiceContextFactory.UserServiceContextFactory userServiceContextFactory;
    private final KsqlConfig ksqlConfig;
    private final Supplier<SchemaRegistryClient> schemaRegistryClientFactory;
    private final ConnectClientFactory connectClientFactory;
    private final KsqlClient sharedClient;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public DefaultKsqlSecurityContextProvider(KsqlSecurityExtension securityExtension, RestServiceContextFactory.DefaultServiceContextFactory defaultServiceContextFactory, RestServiceContextFactory.UserServiceContextFactory userServiceContextFactory, KsqlConfig ksqlConfig, Supplier<SchemaRegistryClient> schemaRegistryClientFactory, ConnectClientFactory connectClientFactory, KsqlClient sharedClient) {
        this.securityExtension = securityExtension;
        this.defaultServiceContextFactory = defaultServiceContextFactory;
        this.userServiceContextFactory = userServiceContextFactory;
        this.ksqlConfig = ksqlConfig;
        this.schemaRegistryClientFactory = schemaRegistryClientFactory;
        this.connectClientFactory = connectClientFactory;
        this.sharedClient = sharedClient;
    }

    @Override
    public KsqlSecurityContext provide(ApiSecurityContext apiSecurityContext) {
        boolean requiresUserContext;
        Optional<KsqlPrincipal> principal = apiSecurityContext.getPrincipal();
        Optional<String> authHeader = apiSecurityContext.getAuthHeader();
        List<Map.Entry<String, String>> requestHeaders = apiSecurityContext.getRequestHeaders();
        boolean bl = requiresUserContext = this.securityExtension != null && this.securityExtension.getUserContextProvider().isPresent() && principal.isPresent();
        if (!requiresUserContext) {
            return new KsqlSecurityContext(principal, this.defaultServiceContextFactory.create(this.ksqlConfig, authHeader, this.schemaRegistryClientFactory, this.connectClientFactory, this.sharedClient, requestHeaders, principal));
        }
        return this.securityExtension.getUserContextProvider().map(provider -> new KsqlSecurityContext(principal, this.userServiceContextFactory.create(this.ksqlConfig, authHeader, (KafkaClientSupplier)provider.getKafkaClientSupplier((Principal)principal.get()), provider.getSchemaRegistryClientFactory((Principal)principal.get()), this.connectClientFactory, this.sharedClient, requestHeaders, principal))).get();
    }

    @Override
    public void close() {
        this.connectClientFactory.close();
    }
}

