/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.impl;

import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.impl.KeyValueExtractor;
import io.confluent.ksql.api.server.InsertResult;
import io.confluent.ksql.api.server.InsertsStreamSubscriber;
import io.confluent.ksql.api.util.ApiSqlValueCoercer;
import io.confluent.ksql.logging.processing.NoopProcessingLogContext;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.reactive.BaseSubscriber;
import io.confluent.ksql.reactive.BufferedPublisher;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.PhysicalSchema;
import io.confluent.ksql.schema.ksql.SqlValueCoercer;
import io.confluent.ksql.serde.GenericKeySerDe;
import io.confluent.ksql.serde.GenericRowSerDe;
import io.confluent.ksql.serde.SerdeFeatures;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.VertxUtils;
import io.vertx.core.Context;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class InsertsSubscriber
extends BaseSubscriber<JsonObject>
implements InsertsStreamSubscriber {
    private static final Logger log = LogManager.getLogger(InsertsSubscriber.class);
    private static final int REQUEST_BATCH_SIZE = 200;
    private static final SqlValueCoercer SQL_VALUE_COERCER = ApiSqlValueCoercer.INSTANCE;
    private final Producer<byte[], byte[]> producer;
    private final DataSource dataSource;
    private final Serializer<GenericKey> keySerializer;
    private final Serializer<GenericRow> valueSerializer;
    private final BufferedPublisher<InsertResult> acksPublisher;
    private final WorkerExecutor workerExecutor;
    private int outstandingTokens;
    private boolean drainHandlerSet;
    private long sequence;

    public static InsertsSubscriber createInsertsSubscriber(ServiceContext serviceContext, JsonObject properties, DataSource dataSource, KsqlConfig ksqlConfig, Context context, Subscriber<InsertResult> acksSubscriber, WorkerExecutor workerExecutor) {
        KsqlConfig configCopy = ksqlConfig.cloneWithPropertyOverwrite(properties.getMap());
        Producer producer = serviceContext.getKafkaClientSupplier().getProducer(configCopy.originals());
        PhysicalSchema physicalSchema = PhysicalSchema.from((LogicalSchema)dataSource.getSchema(), (SerdeFeatures)dataSource.getKsqlTopic().getKeyFormat().getFeatures(), (SerdeFeatures)dataSource.getKsqlTopic().getValueFormat().getFeatures());
        GenericKeySerDe keySerdeFactory = new GenericKeySerDe();
        Serde keySerde = keySerdeFactory.create(dataSource.getKsqlTopic().getKeyFormat().getFormatInfo(), physicalSchema.keySchema(), ksqlConfig, serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty());
        GenericRowSerDe valueSerdeFactory = new GenericRowSerDe();
        Serde valueSerde = valueSerdeFactory.create(dataSource.getKsqlTopic().getValueFormat().getFormatInfo(), physicalSchema.valueSchema(), ksqlConfig, serviceContext.getSchemaRegistryClientFactory(), "", NoopProcessingLogContext.INSTANCE, Optional.empty());
        BufferedPublisher acksPublisher = new BufferedPublisher(context);
        acksPublisher.subscribe(acksSubscriber);
        return new InsertsSubscriber(context, (Producer<byte[], byte[]>)producer, dataSource, (Serializer<GenericKey>)keySerde.serializer(), (Serializer<GenericRow>)valueSerde.serializer(), (BufferedPublisher<InsertResult>)acksPublisher, workerExecutor);
    }

    private InsertsSubscriber(Context context, Producer<byte[], byte[]> producer, DataSource dataSource, Serializer<GenericKey> keySerializer, Serializer<GenericRow> valueSerializer, BufferedPublisher<InsertResult> acksPublisher, WorkerExecutor workerExecutor) {
        super(context);
        this.producer = Objects.requireNonNull(producer);
        this.dataSource = Objects.requireNonNull(dataSource);
        this.keySerializer = Objects.requireNonNull(keySerializer);
        this.valueSerializer = Objects.requireNonNull(valueSerializer);
        this.acksPublisher = Objects.requireNonNull(acksPublisher);
        this.workerExecutor = Objects.requireNonNull(workerExecutor);
    }

    @Override
    public void close() {
        this.executeOnWorker(() -> this.producer.close());
    }

    protected void afterSubscribe(Subscription subscription) {
        this.checkRequest();
    }

    protected void handleValue(JsonObject jsonObjectWithCaseInsensitiveFields) {
        try {
            JsonObject jsonObject = KeyValueExtractor.convertColumnNameCase(jsonObjectWithCaseInsensitiveFields);
            GenericKey key = this.extractKey(jsonObject);
            GenericRow values = this.extractValues(jsonObject);
            String topicName = this.dataSource.getKafkaTopicName();
            byte[] keyBytes = this.keySerializer.serialize(topicName, (Object)key);
            byte[] valueBytes = this.valueSerializer.serialize(topicName, (Object)values);
            ProducerRecord record = new ProducerRecord(topicName, null, Long.valueOf(System.currentTimeMillis()), (Object)keyBytes, (Object)valueBytes);
            --this.outstandingTokens;
            this.producer.send(record, (Callback)new SendCallback(this.sequence));
        }
        catch (Exception e) {
            this.acksPublisher.accept((Object)InsertResult.failedInsert(this.sequence, e));
        }
        ++this.sequence;
    }

    private void handleResult(InsertResult result) {
        VertxUtils.checkContext((Context)this.context);
        boolean full = this.acksPublisher.accept((Object)result);
        if (full) {
            if (!this.drainHandlerSet) {
                this.acksPublisher.drainHandler(this::acksPublisherReceptive);
                this.drainHandlerSet = true;
            }
        } else {
            this.checkRequest();
        }
    }

    private void acksPublisherReceptive() {
        this.drainHandlerSet = false;
        this.checkRequest();
    }

    private void checkRequest() {
        if (this.outstandingTokens == 0) {
            this.outstandingTokens = 200;
            this.makeRequest(200L);
        }
    }

    private GenericKey extractKey(JsonObject values) {
        return KeyValueExtractor.extractKey(values, this.dataSource.getSchema(), SQL_VALUE_COERCER);
    }

    private GenericRow extractValues(JsonObject values) {
        return KeyValueExtractor.extractValues(values, this.dataSource.getSchema(), SQL_VALUE_COERCER);
    }

    private void executeOnWorker(Runnable runnable) {
        this.workerExecutor.executeBlocking(p -> runnable.run(), false, ar -> {
            if (ar.failed()) {
                log.error("Failed to close producer", ar.cause());
            }
        });
    }

    private class SendCallback
    implements Callback {
        private final long seq;

        SendCallback(long seq) {
            this.seq = seq;
        }

        public void onCompletion(RecordMetadata metadata, Exception exception) {
            InsertResult result = exception != null ? InsertResult.failedInsert(this.seq, exception) : InsertResult.succeededInsert(this.seq);
            InsertsSubscriber.this.context.runOnContext(v -> InsertsSubscriber.this.handleResult(result));
        }
    }
}

