/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.api.impl.BlockingPrintPublisher;
import io.confluent.ksql.api.impl.BlockingQueryPublisher;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.api.server.QueryHandle;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.PrintTopic;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.query.BlockingRowQueue;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.reactive.BasePublisher;
import io.confluent.ksql.rest.server.query.QueryExecutor;
import io.confluent.ksql.rest.server.query.QueryMetadataHolder;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.utils.FormatOptions;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.ConsistencyOffsetVector;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.PushQueryMetadata;
import io.confluent.ksql.util.VertxUtils;
import io.vertx.core.Context;
import io.vertx.core.WorkerExecutor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class QueryEndpoint {
    private final KsqlExecutionContext ksqlEngine;
    private final KsqlConfig ksqlConfig;
    private final Optional<PullQueryExecutorMetrics> pullQueryMetrics;
    private final QueryExecutor queryExecutor;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public QueryEndpoint(KsqlExecutionContext ksqlEngine, KsqlConfig ksqlConfig, Optional<PullQueryExecutorMetrics> pullQueryMetrics, QueryExecutor queryExecutor) {
        this.ksqlEngine = ksqlEngine;
        this.ksqlConfig = ksqlConfig;
        this.pullQueryMetrics = pullQueryMetrics;
        this.queryExecutor = queryExecutor;
    }

    public BasePublisher<?> createQueryPublisher(String sql, Map<String, Object> properties, Map<String, Object> sessionVariables, Map<String, Object> requestProperties, Context context, WorkerExecutor workerExecutor, ServiceContext serviceContext, MetricsCallbackHolder metricsCallbackHolder, Optional<Boolean> isInternalRequest) {
        VertxUtils.checkIsWorker();
        ConfiguredStatement<Statement> statement = this.createStatement(sql, properties, sessionVariables);
        if (statement.getStatement() instanceof PrintTopic) {
            BlockingPrintPublisher printPublisher = new BlockingPrintPublisher(context, workerExecutor, serviceContext, this.ksqlConfig, properties, (PrintTopic)statement.getStatement());
            printPublisher.startFromWorkerThread();
            return printPublisher;
        }
        QueryMetadataHolder queryMetadataHolder = this.queryExecutor.handleStatement(serviceContext, properties, requestProperties, statement.getPreparedStatement(), isInternalRequest, metricsCallbackHolder, context, false);
        if (queryMetadataHolder.getPullQueryResult().isPresent()) {
            PullQueryResult result = queryMetadataHolder.getPullQueryResult().get();
            BlockingQueryPublisher publisher = new BlockingQueryPublisher(context, workerExecutor);
            publisher.setQueryHandle(new KsqlPullQueryHandle(result, this.pullQueryMetrics, statement.getPreparedStatement().getMaskedStatementText()), true, false);
            publisher.startFromWorkerThread();
            return publisher;
        }
        if (queryMetadataHolder.getPushQueryMetadata().isPresent()) {
            PushQueryMetadata metadata = queryMetadataHolder.getPushQueryMetadata().get();
            BlockingQueryPublisher publisher = new BlockingQueryPublisher(context, workerExecutor);
            publisher.setQueryHandle(new KsqlQueryHandle(metadata), false, queryMetadataHolder.getScalablePushQueryMetadata().isPresent());
            return publisher;
        }
        throw new KsqlStatementException("Unexpected metadata for query", statement.getMaskedStatementText());
    }

    private ConfiguredStatement<Statement> createStatement(String queryString, Map<String, Object> properties, Map<String, Object> sessionVariables) {
        List statements = this.ksqlEngine.parse(queryString);
        if (statements.size() != 1) {
            throw new KsqlStatementException(String.format("Expected exactly one KSQL statement; found %d instead", statements.size()), queryString);
        }
        KsqlParser.PreparedStatement ps = this.ksqlEngine.prepare((KsqlParser.ParsedStatement)statements.get(0), sessionVariables.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString())));
        Statement statement = ps.getStatement();
        if (!(statement instanceof Query) && !(statement instanceof PrintTopic)) {
            throw new KsqlStatementException("Neither a query nor a print statement", queryString);
        }
        KsqlParser.PreparedStatement psq = ps;
        return ConfiguredStatement.of((KsqlParser.PreparedStatement)psq, (SessionConfig)SessionConfig.of((KsqlConfig)this.ksqlConfig, properties));
    }

    private static List<String> colTypesFromSchema(List<Column> columns) {
        return columns.stream().map(Column::type).map(type -> type.toString(FormatOptions.none())).collect(Collectors.toList());
    }

    private static List<String> colNamesFromSchema(List<Column> columns) {
        return columns.stream().map(Column::name).map(Name::text).collect(Collectors.toList());
    }

    private static class KsqlPullQueryHandle
    implements QueryHandle {
        private final PullQueryResult result;
        private final Optional<PullQueryExecutorMetrics> pullQueryMetrics;
        private final String maskedStatementText;
        private final CompletableFuture<Void> future = new CompletableFuture();

        KsqlPullQueryHandle(PullQueryResult result, Optional<PullQueryExecutorMetrics> pullQueryMetrics, String maskedStatementText) {
            this.result = Objects.requireNonNull(result);
            this.pullQueryMetrics = Objects.requireNonNull(pullQueryMetrics);
            this.maskedStatementText = maskedStatementText;
        }

        @Override
        public List<String> getColumnNames() {
            return QueryEndpoint.colNamesFromSchema(this.result.getSchema().columns());
        }

        @Override
        public List<String> getColumnTypes() {
            return QueryEndpoint.colTypesFromSchema(this.result.getSchema().columns());
        }

        @Override
        public LogicalSchema getLogicalSchema() {
            return this.result.getSchema();
        }

        @Override
        public void start() {
            try {
                this.result.onException(this.future::completeExceptionally);
                this.result.onCompletion(this.future::complete);
                this.result.start();
            }
            catch (Exception e) {
                this.pullQueryMetrics.ifPresent(metrics -> metrics.recordErrorRate(1.0, this.result.getSourceType(), this.result.getPlanType(), this.result.getRoutingNodeType()));
                if (e instanceof KsqlServerException) {
                    throw e;
                }
                throw new KsqlStatementException("Error starting pull query: " + e.getMessage(), this.maskedStatementText, (Throwable)e);
            }
        }

        @Override
        public void stop() {
            this.result.stop();
        }

        @Override
        public BlockingRowQueue getQueue() {
            return this.result.getPullQueryQueue();
        }

        @Override
        public void onException(Consumer<Throwable> onException) {
            this.future.exceptionally(t -> {
                onException.accept((Throwable)t);
                return null;
            });
        }

        @Override
        public QueryId getQueryId() {
            return this.result.getQueryId();
        }

        @Override
        public Optional<ConsistencyOffsetVector> getConsistencyOffsetVector() {
            return this.result.getConsistencyOffsetVector();
        }

        @Override
        public Optional<PushQueryMetadata.ResultType> getResultType() {
            return Optional.empty();
        }
    }

    private static class KsqlQueryHandle
    implements QueryHandle {
        private final PushQueryMetadata queryMetadata;

        KsqlQueryHandle(PushQueryMetadata queryMetadata) {
            this.queryMetadata = Objects.requireNonNull(queryMetadata, "queryMetadata");
        }

        @Override
        public List<String> getColumnNames() {
            return QueryEndpoint.colNamesFromSchema(this.queryMetadata.getLogicalSchema().value());
        }

        @Override
        public List<String> getColumnTypes() {
            return QueryEndpoint.colTypesFromSchema(this.queryMetadata.getLogicalSchema().value());
        }

        @Override
        public LogicalSchema getLogicalSchema() {
            return this.queryMetadata.getLogicalSchema();
        }

        @Override
        public void start() {
            this.queryMetadata.start();
        }

        @Override
        public void stop() {
            this.queryMetadata.close();
        }

        @Override
        public BlockingRowQueue getQueue() {
            return this.queryMetadata.getRowQueue();
        }

        @Override
        public void onException(Consumer<Throwable> onException) {
            this.queryMetadata.setUncaughtExceptionHandler(throwable -> {
                onException.accept(throwable);
                return null;
            });
        }

        @Override
        public QueryId getQueryId() {
            return this.queryMetadata.getQueryId();
        }

        @Override
        public Optional<ConsistencyOffsetVector> getConsistencyOffsetVector() {
            return Optional.empty();
        }

        @Override
        public Optional<PushQueryMetadata.ResultType> getResultType() {
            return Optional.of(this.queryMetadata.getResultType());
        }
    }
}

