/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.auth.DefaultApiSecurityContext;
import io.confluent.ksql.api.server.AcksSubscriber;
import io.confluent.ksql.api.server.DelimitedInsertsStreamResponseWriter;
import io.confluent.ksql.api.server.InsertResult;
import io.confluent.ksql.api.server.InsertsStreamResponseWriter;
import io.confluent.ksql.api.server.InsertsStreamSubscriber;
import io.confluent.ksql.api.server.JsonInsertsStreamResponseWriter;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.api.spi.Endpoints;
import io.confluent.ksql.reactive.BufferedPublisher;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.InsertError;
import io.confluent.ksql.rest.entity.InsertsStreamArgs;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.WorkerExecutor;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Subscriber;

public class InsertsStreamHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = LogManager.getLogger(InsertsStreamHandler.class);
    private final Context ctx;
    private final Endpoints endpoints;
    private final Server server;
    private final WorkerExecutor workerExecutor;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public InsertsStreamHandler(Context ctx, Endpoints endpoints, Server server) {
        this.ctx = Objects.requireNonNull(ctx);
        this.endpoints = Objects.requireNonNull(endpoints);
        this.server = Objects.requireNonNull(server);
        this.workerExecutor = Objects.requireNonNull(server.getWorkerExecutor());
    }

    public void handle(RoutingContext routingContext) {
        if (!ServerUtils.checkHttp2(routingContext)) {
            return;
        }
        RecordParser recordParser = RecordParser.newDelimited((String)"\n", (ReadStream)routingContext.request());
        RequestHandler requestHandler = new RequestHandler(routingContext, recordParser);
        recordParser.handler(requestHandler::handleBodyBuffer);
        recordParser.endHandler(requestHandler::handleBodyEnd);
    }

    private class RequestHandler {
        private final RoutingContext routingContext;
        private final RecordParser recordParser;
        private final InsertsStreamResponseWriter insertsStreamResponseWriter;
        private final UUID uuid;
        private boolean hasReadArguments;
        private BufferedPublisher<JsonObject> publisher;
        private long rowsReceived;
        private AcksSubscriber acksSubscriber;
        private boolean paused;
        private boolean responseEnded;
        private long sendSequence;
        private InsertsStreamSubscriber insertsSubscriber;

        RequestHandler(RoutingContext routingContext, RecordParser recordParser) {
            this.routingContext = Objects.requireNonNull(routingContext);
            this.recordParser = Objects.requireNonNull(recordParser);
            this.uuid = UUID.randomUUID();
            String contentType = routingContext.getAcceptableContentType();
            this.insertsStreamResponseWriter = "application/vnd.ksqlapi.delimited.v1".equals(contentType) || contentType == null ? new DelimitedInsertsStreamResponseWriter(routingContext.response(), this.uuid) : new JsonInsertsStreamResponseWriter(routingContext.response(), this.uuid);
        }

        private void handleBodyBuffer(Buffer buff) {
            if (this.responseEnded) {
                return;
            }
            if (!this.hasReadArguments) {
                this.handleArgs(buff);
            } else if (this.publisher != null) {
                this.handleRow(buff);
            }
        }

        private void handleArgs(Buffer buff) {
            this.hasReadArguments = true;
            Optional<InsertsStreamArgs> insertsStreamArgs = ServerUtils.deserialiseObject(buff, this.routingContext, InsertsStreamArgs.class);
            if (!insertsStreamArgs.isPresent()) {
                return;
            }
            LOG.debug("({}) Processed insert stream args: {}", (Object)this.uuid, (Object)insertsStreamArgs.get());
            this.routingContext.response().endHandler(v -> this.handleResponseEnd());
            this.acksSubscriber = new AcksSubscriber(InsertsStreamHandler.this.ctx, this.routingContext.response(), this.insertsStreamResponseWriter);
            this.recordParser.pause();
            ((CompletableFuture)InsertsStreamHandler.this.endpoints.createInsertsSubscriber(insertsStreamArgs.get().target, insertsStreamArgs.get().properties, (Subscriber<InsertResult>)this.acksSubscriber, InsertsStreamHandler.this.ctx, InsertsStreamHandler.this.workerExecutor, DefaultApiSecurityContext.create(this.routingContext, InsertsStreamHandler.this.server)).thenAccept(insertsSubscriber -> {
                this.publisher = new BufferedPublisher(InsertsStreamHandler.this.ctx);
                LOG.debug("({}) Acknowledging insert stream in subscriber after creating publisher.", (Object)this.uuid);
                this.routingContext.response().write("");
                this.publisher.subscribe((Subscriber)insertsSubscriber);
                this.recordParser.resume();
                this.insertsSubscriber = insertsSubscriber;
            })).exceptionally(t -> ServerUtils.handleEndpointException(t, this.routingContext, "Failed to execute inserts"));
        }

        private void handleRow(Buffer buff) {
            JsonObject row;
            long seq = this.sendSequence++;
            try {
                row = new JsonObject(buff);
                LOG.debug("({}) Handling insert stream row: {}", (Object)this.uuid, (Object)row);
            }
            catch (DecodeException e) {
                InsertError errorResponse = new InsertError(seq, Errors.ERROR_CODE_BAD_REQUEST, "Invalid JSON in inserts stream");
                LOG.warn("({}) Failed to process row at sequence {} ({})", (Object)this.uuid, (Object)this.sendSequence, (Object)buff.toString(), (Object)e);
                this.insertsStreamResponseWriter.writeError(errorResponse).end();
                this.acksSubscriber.cancel();
                return;
            }
            boolean bufferFull = this.publisher.accept((Object)row);
            if (bufferFull && !this.paused) {
                LOG.debug("({}) Buffer is full after processing {} records. Pausing the parser", (Object)this.uuid, (Object)this.sendSequence);
                this.recordParser.pause();
                this.publisher.drainHandler(this::publisherReceptive);
                this.paused = true;
            }
            ++this.rowsReceived;
        }

        private void publisherReceptive() {
            LOG.debug("({}) Resuming record parser after draining publisher.", (Object)this.uuid);
            this.paused = false;
            this.recordParser.resume();
        }

        private void handleBodyEnd(Void v) {
            LOG.debug("({}) Completed reading the request, ending the response. Completing Publisher: {}, Closing Publisher: {}", (Object)this.uuid, (Object)(this.publisher != null ? 1 : 0), (Object)(this.acksSubscriber == null ? 1 : 0));
            if (this.publisher != null) {
                this.publisher.complete();
                if (this.acksSubscriber == null) {
                    this.routingContext.response().end();
                } else {
                    this.acksSubscriber.insertsSent(this.rowsReceived);
                }
            }
        }

        private void handleResponseEnd() {
            this.responseEnded = true;
            if (this.insertsSubscriber != null) {
                this.insertsSubscriber.close();
            }
        }
    }
}

