/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.rest.Errors;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Set;

public class InternalEndpointHandler
implements Handler<RoutingContext> {
    public static final String CONTEXT_DATA_IS_INTERNAL = "isInternal";
    private static final Set<String> INTERNAL_PATHS = ImmutableSet.of((Object)"/heartbeat", (Object)"/lag");
    private final boolean isFromInternalListener;

    public InternalEndpointHandler(boolean isFromInternalListener) {
        this.isFromInternalListener = isFromInternalListener;
    }

    public void handle(RoutingContext routingContext) {
        if (INTERNAL_PATHS.contains(routingContext.normalisedPath()) && !this.isFromInternalListener) {
            routingContext.fail(HttpResponseStatus.BAD_REQUEST.code(), (Throwable)((Object)new KsqlApiException("Can't call internal endpoint on public listener", Errors.ERROR_CODE_SERVER_ERROR)));
        } else {
            routingContext.put(CONTEXT_DATA_IS_INTERNAL, (Object)this.isFromInternalListener);
            routingContext.next();
        }
    }
}

