/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.auth.ApiUser;
import io.confluent.ksql.api.server.LoggingRateLimiter;
import io.confluent.ksql.api.server.Server;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.Utils;
import java.time.Clock;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LoggingHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = LogManager.getLogger(LoggingHandler.class);
    static final String HTTP_HEADER_USER_AGENT = "User-Agent";
    private final Logger logger;
    private final Clock clock;
    private final LoggingRateLimiter loggingRateLimiter;
    private final Optional<Pattern> endpointFilter;
    private final boolean enableQueryLogging;

    public LoggingHandler(Server server, LoggingRateLimiter loggingRateLimiter) {
        this(server, loggingRateLimiter, LOG, Clock.systemUTC());
    }

    @VisibleForTesting
    LoggingHandler(Server server, LoggingRateLimiter loggingRateLimiter, Logger logger, Clock clock) {
        Optional endpointFilter;
        Objects.requireNonNull(server);
        this.loggingRateLimiter = Objects.requireNonNull(loggingRateLimiter);
        this.logger = logger;
        this.clock = clock;
        String endpointRegex = server.getConfig().getString("ksql.endpoint.logging.ignored.paths.regex");
        try {
            endpointFilter = endpointRegex.isEmpty() ? Optional.empty() : Optional.of(Pattern.compile(endpointRegex));
        }
        catch (Exception e) {
            LOG.warn("Could not set up regex for Logging Handler", (Throwable)e);
            endpointFilter = Optional.empty();
        }
        this.endpointFilter = endpointFilter;
        this.enableQueryLogging = server.getConfig().getBoolean("ksql.endpoint.logging.log.queries");
    }

    public void handle(RoutingContext routingContext) {
        routingContext.addEndHandler(ar -> {
            String uri;
            int status = routingContext.request().response().getStatusCode();
            if (!this.loggingRateLimiter.shouldLog(this.logger, routingContext.request().path(), status)) {
                return;
            }
            long contentLength = routingContext.request().response().bytesWritten();
            HttpVersion version = routingContext.request().version();
            HttpMethod method = routingContext.request().method();
            String string = uri = this.enableQueryLogging ? routingContext.request().uri() : routingContext.request().path();
            if (this.endpointFilter.isPresent() && this.endpointFilter.get().matcher(uri).matches()) {
                return;
            }
            long requestBodyLength = routingContext.request().bytesRead();
            String versionFormatted = switch (version) {
                case HttpVersion.HTTP_1_0 -> "HTTP/1.0";
                case HttpVersion.HTTP_1_1 -> "HTTP/1.1";
                case HttpVersion.HTTP_2 -> "HTTP/2.0";
                default -> "-";
            };
            String name = Optional.ofNullable((ApiUser)routingContext.user()).map(u -> u.getPrincipal().getName()).orElse("-");
            String userAgent = Optional.ofNullable(routingContext.request().getHeader(HTTP_HEADER_USER_AGENT)).orElse("-");
            String timestamp = Utils.formatRFC1123DateTime((long)this.clock.millis());
            SocketAddress socketAddress = routingContext.request().remoteAddress();
            String message = String.format("%s - %s [%s] \"%s %s %s\" %d %d \"-\" \"%s\" %d", socketAddress == null ? "null" : socketAddress.host(), name, timestamp, method, uri, versionFormatted, status, contentLength, userAgent, requestBodyLength);
            this.doLog(status, message);
        });
        routingContext.next();
    }

    private void doLog(int status, String message) {
        if (status >= 500) {
            this.logger.error(message);
        } else if (status >= 400) {
            this.logger.warn(message);
        } else {
            this.logger.info(message);
        }
    }
}

