/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.VertxUtils;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class ResponseOutputStream
extends OutputStream {
    private static final int BLOCK_TIME_MS = 100;
    private final HttpServerResponse response;
    private final int writeTimeoutMs;
    private volatile boolean closed;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ResponseOutputStream(HttpServerResponse response, int writeTimeoutMs) {
        this.response = response;
        this.writeTimeoutMs = writeTimeoutMs;
    }

    @Override
    public void write(int b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void write(@NotNull byte[] bytes, int offset, int length) throws IOException {
        if (this.closed) {
            throw new EOFException("ResponseOutputStream is closed");
        }
        Objects.requireNonNull(bytes);
        if (offset < 0 || offset > bytes.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length < 0 || offset + length > bytes.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        byte[] bytesToWrite = new byte[length];
        System.arraycopy(bytes, offset, bytesToWrite, 0, length);
        Buffer buffer = Buffer.buffer((byte[])bytesToWrite);
        this.blockIfWriteQueueFull();
        this.response.write((Object)buffer);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.response.end();
    }

    private void blockIfWriteQueueFull() throws IOException {
        VertxUtils.checkIsWorker();
        if (this.response.writeQueueFull()) {
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            this.response.drainHandler(v -> cf.complete(null));
            this.blockOnWrite(cf);
        }
    }

    private void blockOnWrite(CompletableFuture<Void> cf) throws IOException {
        long start = System.currentTimeMillis();
        do {
            if (this.closed) {
                throw new EOFException("ResponseOutputStream is closed");
            }
            try {
                cf.get(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (Exception e) {
                throw new KsqlException((Throwable)e);
            }
        } while (System.currentTimeMillis() - start < (long)this.writeTimeoutMs);
        throw new KsqlException("Timed out waiting to write to client");
    }
}

