/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.util.KsqlRateLimitException;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.KsqlStatementException;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpVersion;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerUtils {
    private static final Logger log = LogManager.getLogger(ServerUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = ApiJsonMapper.INSTANCE.get();

    private ServerUtils() {
    }

    public static <T> Optional<T> deserialiseObject(Buffer buffer, RoutingContext routingContext, Class<T> clazz) {
        try {
            return Optional.of(OBJECT_MAPPER.readValue(buffer.getBytes(), clazz));
        }
        catch (JsonParseException | MismatchedInputException e) {
            routingContext.fail(HttpResponseStatus.BAD_REQUEST.code(), (Throwable)((Object)new KsqlApiException("Invalid JSON in request: " + e.getMessage(), Errors.ERROR_CODE_BAD_REQUEST)));
            return Optional.empty();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize buffer", e);
        }
    }

    public static <T> Buffer serializeObject(T t) {
        try {
            byte[] bytes = OBJECT_MAPPER.writeValueAsBytes(t);
            return Buffer.buffer((byte[])bytes);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to serialize buffer", e);
        }
    }

    public static String convertCommaSeparatedWilcardsToRegex(String csv) {
        String[] parts = csv.split(",");
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            part = part.replace(".", "\\.").replace("+", "\\+").replace("?", "\\?").replace("-", "\\-").replace("*", ".*");
            out.append(part);
            if (i == parts.length - 1) continue;
            out.append('|');
        }
        return out.toString();
    }

    public static boolean checkHttp2(RoutingContext routingContext) {
        if (routingContext.request().version() != HttpVersion.HTTP_2) {
            routingContext.fail(HttpResponseStatus.BAD_REQUEST.code(), (Throwable)((Object)new KsqlApiException("This endpoint is only available when using HTTP2", Errors.ERROR_CODE_HTTP2_ONLY)));
            return false;
        }
        return true;
    }

    static Void handleEndpointException(Throwable t, RoutingContext routingContext, String logMsg) {
        if (t instanceof CompletionException) {
            Throwable actual = t.getCause();
            log.error(logMsg, actual);
            if (actual instanceof KsqlStatementException) {
                routingContext.fail(HttpResponseStatus.BAD_REQUEST.code(), (Throwable)((Object)new KsqlApiException(((KsqlStatementException)actual).getUnloggedMessage(), Errors.ERROR_CODE_BAD_STATEMENT, ((KsqlStatementException)actual).getSqlStatement())));
                return null;
            }
            if (actual instanceof KsqlRateLimitException) {
                routingContext.fail(HttpResponseStatus.TOO_MANY_REQUESTS.code(), (Throwable)((Object)new KsqlApiException(actual.getMessage(), Errors.ERROR_CODE_TOO_MANY_REQUESTS)));
                return null;
            }
            if (actual instanceof KsqlServerException) {
                routingContext.fail(HttpResponseStatus.SERVICE_UNAVAILABLE.code(), actual);
                return null;
            }
            if (actual instanceof KsqlApiException) {
                routingContext.fail(HttpResponseStatus.BAD_REQUEST.code(), actual);
                return null;
            }
        } else {
            log.error(logMsg, t);
        }
        routingContext.fail(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), (Throwable)((Object)new KsqlApiException("The server encountered an internal error when processing the query. Please consult the server logs for more information.", Errors.ERROR_CODE_SERVER_ERROR)));
        return null;
    }
}

