/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.util;

import io.confluent.ksql.schema.ksql.DefaultSqlValueCoercer;
import io.confluent.ksql.schema.ksql.SchemaConverters;
import io.confluent.ksql.schema.ksql.SqlValueCoercer;
import io.confluent.ksql.schema.ksql.types.SqlArray;
import io.confluent.ksql.schema.ksql.types.SqlDecimal;
import io.confluent.ksql.schema.ksql.types.SqlMap;
import io.confluent.ksql.schema.ksql.types.SqlStruct;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.JsonUtil;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Struct;

public enum ApiSqlValueCoercer implements SqlValueCoercer
{
    INSTANCE;

    private static final SqlValueCoercer DEFAULT_COERCER;

    public SqlValueCoercer.Result coerce(Object value, SqlType targetType) {
        return this.doCoerce(value, targetType);
    }

    private SqlValueCoercer.Result doCoerce(Object value, SqlType targetType) {
        if (value == null) {
            return SqlValueCoercer.Result.nullResult();
        }
        switch (targetType.baseType()) {
            case DECIMAL: {
                return ApiSqlValueCoercer.coerceDecimal(value, (SqlDecimal)targetType);
            }
            case ARRAY: {
                return this.coerceArray(value, (SqlArray)targetType);
            }
            case MAP: {
                return this.coerceMap(value, (SqlMap)targetType);
            }
            case STRUCT: {
                return this.coerceStruct(value, (SqlStruct)targetType);
            }
        }
        return ApiSqlValueCoercer.defaultCoerce(value, targetType);
    }

    private static SqlValueCoercer.Result coerceDecimal(Object value, SqlDecimal targetType) {
        if (value instanceof Double) {
            return SqlValueCoercer.Result.of((Object)new BigDecimal(String.valueOf(value)).setScale(targetType.getScale(), RoundingMode.HALF_UP));
        }
        if (value instanceof String) {
            return SqlValueCoercer.Result.of((Object)new BigDecimal((String)value).setScale(targetType.getScale(), RoundingMode.HALF_UP));
        }
        return ApiSqlValueCoercer.defaultCoerce(value, (SqlType)targetType);
    }

    private SqlValueCoercer.Result coerceStruct(Object value, SqlStruct targetType) {
        if (!(value instanceof JsonObject)) {
            return SqlValueCoercer.Result.failure();
        }
        JsonObject struct = JsonUtil.convertJsonFieldCase((JsonObject)((JsonObject)value));
        Struct coerced = new Struct(SchemaConverters.sqlToConnectConverter().toConnectSchema((SqlType)targetType));
        for (Field field : coerced.schema().fields()) {
            Optional sqlField = targetType.field(field.name());
            if (!sqlField.isPresent()) {
                return SqlValueCoercer.Result.failure();
            }
            if (!struct.fieldNames().contains(field.name())) continue;
            SqlValueCoercer.Result val = this.doCoerce(struct.getValue(field.name()), ((SqlStruct.Field)sqlField.get()).type());
            if (val.failed()) {
                return SqlValueCoercer.Result.failure();
            }
            val.value().ifPresent(v -> coerced.put(field.name(), v));
        }
        return SqlValueCoercer.Result.of((Object)coerced);
    }

    private SqlValueCoercer.Result coerceArray(Object value, SqlArray targetType) {
        if (!(value instanceof JsonArray)) {
            return SqlValueCoercer.Result.failure();
        }
        JsonArray array = (JsonArray)value;
        ArrayList<Object> coerced = new ArrayList<Object>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            SqlValueCoercer.Result result = this.doCoerce(array.getValue(i), targetType.getItemType());
            if (result.failed()) {
                return SqlValueCoercer.Result.failure();
            }
            coerced.add(result.value().orElse(null));
        }
        return SqlValueCoercer.Result.of(coerced);
    }

    private SqlValueCoercer.Result coerceMap(Object value, SqlMap targetType) {
        if (!(value instanceof JsonObject)) {
            return SqlValueCoercer.Result.failure();
        }
        JsonObject map = (JsonObject)value;
        HashMap<Object, Object> coerced = new HashMap<Object, Object>();
        for (String key : map.fieldNames()) {
            SqlValueCoercer.Result coercedKey = this.doCoerce(key, targetType.getKeyType());
            SqlValueCoercer.Result coercedValue = this.doCoerce(map.getValue(key), targetType.getValueType());
            if (coercedKey.failed() || coercedValue.failed()) {
                return SqlValueCoercer.Result.failure();
            }
            coerced.put(coercedKey.value().orElse(null), coercedValue.value().orElse(null));
        }
        return SqlValueCoercer.Result.of(coerced);
    }

    private static SqlValueCoercer.Result defaultCoerce(Object value, SqlType targetType) {
        if (value instanceof JsonObject || value instanceof JsonArray) {
            return SqlValueCoercer.Result.failure();
        }
        return DEFAULT_COERCER.coerce(value, targetType);
    }

    static {
        DEFAULT_COERCER = DefaultSqlValueCoercer.STRICT;
    }
}

