/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.entity;

import com.google.common.collect.ImmutableSet;
import io.confluent.ksql.model.WindowType;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.QueryDescription;
import io.confluent.ksql.rest.util.EntityUtil;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class QueryDescriptionFactory {
    private QueryDescriptionFactory() {
    }

    public static QueryDescription forQueryMetadata(QueryMetadata queryMetadata, Map<KsqlHostInfoEntity, KsqlConstants.KsqlQueryStatus> ksqlHostQueryStatus) {
        if (queryMetadata instanceof PersistentQueryMetadata) {
            PersistentQueryMetadata persistentQuery = (PersistentQueryMetadata)queryMetadata;
            return QueryDescriptionFactory.create((QueryMetadata)persistentQuery, persistentQuery.getResultTopic().map(t -> t.getKeyFormat().getWindowType()).orElse(Optional.empty()), persistentQuery.getSinkName(), ksqlHostQueryStatus);
        }
        return QueryDescriptionFactory.create(queryMetadata, Optional.empty(), Optional.empty(), ksqlHostQueryStatus);
    }

    private static QueryDescription create(QueryMetadata queryMetadata, Optional<WindowType> windowType, Optional<SourceName> sink, Map<KsqlHostInfoEntity, KsqlConstants.KsqlQueryStatus> ksqlHostQueryStatus) {
        return new QueryDescription(queryMetadata.getQueryId(), queryMetadata.getStatementString(), windowType, EntityUtil.buildSourceSchemaEntity(queryMetadata.getLogicalSchema()), queryMetadata.getSourceNames().stream().map(Name::text).collect(Collectors.toSet()), (Set)(sink.isPresent() ? ImmutableSet.of((Object)sink.get().text()) : ImmutableSet.of()), queryMetadata.getTopologyDescription(), queryMetadata.getExecutionPlan(), queryMetadata.getOverriddenProperties(), ksqlHostQueryStatus, queryMetadata.getQueryType(), queryMetadata.getQueryErrors(), queryMetadata.getTaskMetadata(), queryMetadata.getQueryApplicationId());
    }
}

