/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import io.confluent.ksql.execution.streams.RoutingFilter;
import io.confluent.ksql.rest.server.HeartbeatAgent;
import io.confluent.ksql.util.HostStatus;
import io.confluent.ksql.util.KsqlHostInfo;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class LivenessFilter
implements RoutingFilter {
    private final Optional<HeartbeatAgent> heartbeatAgent;

    public LivenessFilter(Optional<HeartbeatAgent> heartbeatAgent) {
        this.heartbeatAgent = Objects.requireNonNull(heartbeatAgent, "heartbeatAgent");
    }

    public RoutingFilter.Host filter(KsqlHostInfo host) {
        if (!this.heartbeatAgent.isPresent()) {
            return RoutingFilter.Host.include((KsqlHostInfo)host);
        }
        Map<KsqlHostInfo, HostStatus> allHostsStatus = this.heartbeatAgent.get().getHostsStatus();
        HostStatus status = allHostsStatus.get(host);
        if (status == null) {
            return RoutingFilter.Host.include((KsqlHostInfo)host);
        }
        if (status.isHostAlive()) {
            return RoutingFilter.Host.include((KsqlHostInfo)host);
        }
        return RoutingFilter.Host.exclude((KsqlHostInfo)host, (String)("Host is not alive as of time " + status.getLastStatusUpdateMs()));
    }
}

