/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import io.confluent.ksql.rest.server.Executable;
import java.util.Objects;

public final class MultiExecutable
implements Executable {
    private final Executable[] executables;

    public static Executable of(Executable ... executables) {
        return new MultiExecutable(executables);
    }

    private MultiExecutable(Executable ... executables) {
        this.executables = Objects.requireNonNull(executables, "executables");
    }

    @Override
    public void startAsync() throws Exception {
        this.doAction(Executable::startAsync);
    }

    @Override
    public void shutdown() throws Exception {
        this.doAction(Executable::shutdown);
    }

    @Override
    public void notifyTerminated() {
        this.doAction(Executable::notifyTerminated);
    }

    @Override
    public void awaitTerminated() throws InterruptedException {
        this.doAction(Executable::awaitTerminated);
    }

    private <T extends Exception> void doAction(ExceptionalConsumer<Executable, T> action) throws T {
        Exception exception = null;
        for (Executable executable : this.executables) {
            try {
                action.accept(executable);
            }
            catch (Exception e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @FunctionalInterface
    private static interface ExceptionalConsumer<I, T extends Exception> {
        public void accept(I var1) throws T;
    }
}

