/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.server.PreconditionVerticle;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.api.util.ApiServerUtils;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.rest.server.state.ServerState;
import io.confluent.ksql.util.FileWatcher;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.VertxCompletableFuture;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.ClientAuth;
import io.vertx.core.http.HttpServerOptions;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PreconditionServer {
    private static final Logger log = LogManager.getLogger(Server.class);
    private final Vertx vertx;
    private final KsqlRestConfig config;
    private final Set<String> deploymentIds = new HashSet<String>();
    private final ServerState serverState;
    private final List<URI> listeners;
    private final Set<URI> proxyProtocolListeners;
    private FileWatcher fileWatcher;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PreconditionServer(Vertx vertx, KsqlRestConfig config, ServerState serverState) {
        this.vertx = Objects.requireNonNull(vertx);
        this.config = Objects.requireNonNull(config);
        this.serverState = Objects.requireNonNull(serverState);
        this.listeners = ImmutableList.copyOf(ApiServerUtils.parseListeners(config));
        this.proxyProtocolListeners = new HashSet<URI>(ApiServerUtils.parseProxyProtocolListeners(config));
    }

    public synchronized void start() {
        if (!this.deploymentIds.isEmpty()) {
            throw new IllegalStateException("Already started");
        }
        int idleConnectionTimeoutSeconds = this.config.getInt("ksql.idle.connection.timeout.seconds");
        this.fileWatcher = ApiServerUtils.configureTlsCertReload(this.config, this::restart);
        int instances = this.config.getInt("ksql.verticle.instances");
        log.debug("Deploying " + instances + " instances of server verticle");
        ArrayList<VertxCompletableFuture> deployFutures = new ArrayList<VertxCompletableFuture>();
        for (URI uRI : this.listeners) {
            boolean bl = this.proxyProtocolListeners.contains(uRI);
            for (int i = 0; i < instances; ++i) {
                VertxCompletableFuture vcf = new VertxCompletableFuture();
                PreconditionVerticle serverVerticle = new PreconditionVerticle(PreconditionServer.createHttpServerOptions(this.config, uRI.getHost(), uRI.getPort(), uRI.getScheme().equalsIgnoreCase("https"), idleConnectionTimeoutSeconds, bl), this.serverState, this.config);
                this.vertx.deployVerticle((Verticle)serverVerticle, (Handler)vcf);
                deployFutures.add(vcf);
            }
        }
        CompletableFuture<Void> allDeployFuture = CompletableFuture.allOf(deployFutures.toArray(new CompletableFuture[0]));
        try {
            allDeployFuture.get();
            for (CompletableFuture completableFuture : deployFutures) {
                this.deploymentIds.add((String)completableFuture.get());
            }
        }
        catch (Exception exception) {
            throw new KsqlException("Failed to start API server", (Throwable)exception);
        }
        log.info("API server started");
        this.listeners.forEach(l -> log.info("Listening on: " + l.toString()));
    }

    public synchronized boolean started() {
        return !this.deploymentIds.isEmpty();
    }

    public synchronized void stop() {
        if (this.deploymentIds.isEmpty()) {
            throw new IllegalStateException("Not started");
        }
        if (this.fileWatcher != null) {
            this.fileWatcher.shutdown();
        }
        ArrayList<VertxCompletableFuture> undeployFutures = new ArrayList<VertxCompletableFuture>();
        for (String deploymentID : this.deploymentIds) {
            VertxCompletableFuture future = new VertxCompletableFuture();
            this.vertx.undeploy(deploymentID, (Handler)future);
            undeployFutures.add(future);
        }
        try {
            CompletableFuture.allOf(undeployFutures.toArray(new CompletableFuture[0])).get();
        }
        catch (Exception e) {
            throw new KsqlException("Failure in stopping API server", (Throwable)e);
        }
        this.deploymentIds.clear();
        log.info("API server stopped");
    }

    public List<URI> getListeners() {
        return ImmutableList.copyOf(this.listeners);
    }

    private void restart() {
        log.info("Restarting precondition server");
        this.stop();
        this.start();
    }

    private static HttpServerOptions createHttpServerOptions(KsqlRestConfig ksqlRestConfig, String host, int port, boolean tls, int idleTimeoutSeconds, boolean useProxyProtocol) {
        HttpServerOptions options = new HttpServerOptions().setHost(host).setPort(port).setReuseAddress(true).setReusePort(true).setIdleTimeout(idleTimeoutSeconds).setIdleTimeoutUnit(TimeUnit.SECONDS).setPerMessageWebSocketCompressionSupported(true).setPerFrameWebSocketCompressionSupported(true).setUseProxyProtocol(useProxyProtocol);
        if (tls) {
            String ksConfigName = "ksql.ssl.keystore.alias.external";
            ClientAuth clientAuth = ksqlRestConfig.getClientAuth();
            String alias = ksqlRestConfig.getString("ksql.ssl.keystore.alias.external");
            ApiServerUtils.setTlsOptions(ksqlRestConfig, options, alias, clientAuth);
        }
        return options;
    }
}

