/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.parser.DropType;
import io.confluent.ksql.parser.tree.AlterSource;
import io.confluent.ksql.parser.tree.AlterSystemProperty;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.DropStream;
import io.confluent.ksql.parser.tree.DropTable;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.PauseQuery;
import io.confluent.ksql.parser.tree.RegisterType;
import io.confluent.ksql.parser.tree.ResumeQuery;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.TerminateQuery;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.util.TerminateCluster;
import java.util.Map;
import java.util.UUID;

public class CommandIdAssigner {
    private static final Map<Class<? extends Statement>, CommandIdSupplier> SUPPLIERS = ImmutableMap.builder().put(CreateStream.class, command -> CommandIdAssigner.getTopicStreamCommandId((CreateStream)command)).put(CreateTable.class, command -> CommandIdAssigner.getTopicTableCommandId((CreateTable)command)).put(CreateStreamAsSelect.class, command -> CommandIdAssigner.getSelectStreamCommandId((CreateStreamAsSelect)command)).put(CreateTableAsSelect.class, command -> CommandIdAssigner.getSelectTableCommandId((CreateTableAsSelect)command)).put(RegisterType.class, command -> CommandIdAssigner.getRegisterTypeCommandId((RegisterType)command)).put(DropType.class, command -> CommandIdAssigner.getDropTypeCommandId((DropType)command)).put(InsertInto.class, command -> CommandIdAssigner.getInsertIntoCommandId((InsertInto)command)).put(PauseQuery.class, command -> CommandIdAssigner.getPauseCommandId((PauseQuery)command)).put(ResumeQuery.class, command -> CommandIdAssigner.getResumeCommandId((ResumeQuery)command)).put(TerminateQuery.class, command -> CommandIdAssigner.getTerminateCommandId((TerminateQuery)command)).put(DropStream.class, command -> CommandIdAssigner.getDropStreamCommandId((DropStream)command)).put(DropTable.class, command -> CommandIdAssigner.getDropTableCommandId((DropTable)command)).put(TerminateCluster.class, command -> CommandIdAssigner.getTerminateClusterCommandId()).put(AlterSource.class, command -> CommandIdAssigner.getAlterSourceCommandId((AlterSource)command)).put(AlterSystemProperty.class, command -> CommandIdAssigner.getAlterSystemCommandId((AlterSystemProperty)command)).build();

    public CommandId getCommandId(Statement command) {
        CommandIdSupplier supplier = SUPPLIERS.get(command.getClass());
        if (supplier == null) {
            throw new RuntimeException(String.format("Cannot assign command ID to statement of type %s", command.getClass().getCanonicalName()));
        }
        return supplier.apply(command);
    }

    private static CommandId getTopicStreamCommandId(CreateStream createStream) {
        return CommandIdAssigner.getStreamCommandId(createStream.getName().toString());
    }

    private static CommandId getSelectStreamCommandId(CreateStreamAsSelect createStreamAsSelect) {
        return CommandIdAssigner.getStreamCommandId(createStreamAsSelect.getName().toString());
    }

    private static CommandId getTopicTableCommandId(CreateTable createTable) {
        return CommandIdAssigner.getTableCommandId(createTable.getName().toString());
    }

    private static CommandId getSelectTableCommandId(CreateTableAsSelect createTableAsSelect) {
        return CommandIdAssigner.getTableCommandId(createTableAsSelect.getName().toString());
    }

    private static CommandId getInsertIntoCommandId(InsertInto insertInto) {
        return new CommandId(CommandId.Type.STREAM, insertInto.getTarget().toString(), CommandId.Action.CREATE);
    }

    private static CommandId getRegisterTypeCommandId(RegisterType registerType) {
        return new CommandId(CommandId.Type.TYPE, registerType.getName(), CommandId.Action.CREATE);
    }

    private static CommandId getDropTypeCommandId(DropType dropType) {
        return new CommandId(CommandId.Type.TYPE, dropType.getTypeName(), CommandId.Action.DROP);
    }

    private static CommandId getPauseCommandId(PauseQuery pauseQuery) {
        return new CommandId(CommandId.Type.PAUSE, pauseQuery.getQueryId().map(QueryId::toString).orElse("ALL"), CommandId.Action.EXECUTE);
    }

    private static CommandId getResumeCommandId(ResumeQuery resumeQuery) {
        return new CommandId(CommandId.Type.RESUME, resumeQuery.getQueryId().map(QueryId::toString).orElse("ALL"), CommandId.Action.EXECUTE);
    }

    private static CommandId getTerminateCommandId(TerminateQuery terminateQuery) {
        return new CommandId(CommandId.Type.TERMINATE, terminateQuery.getQueryId().map(QueryId::toString).orElse("ALL"), CommandId.Action.EXECUTE);
    }

    private static CommandId getDropStreamCommandId(DropStream dropStreamQuery) {
        return new CommandId(CommandId.Type.STREAM, dropStreamQuery.getName().text(), CommandId.Action.DROP);
    }

    private static CommandId getDropTableCommandId(DropTable dropTableQuery) {
        return new CommandId(CommandId.Type.TABLE, dropTableQuery.getName().text(), CommandId.Action.DROP);
    }

    private static CommandId getAlterSourceCommandId(AlterSource alterSource) {
        return new CommandId(alterSource.getDataSourceType() == DataSource.DataSourceType.KSTREAM ? CommandId.Type.STREAM : CommandId.Type.TABLE, alterSource.getName().text(), CommandId.Action.ALTER);
    }

    private static CommandId getAlterSystemCommandId(AlterSystemProperty alterSystemProperty) {
        return new CommandId(CommandId.Type.CLUSTER, UUID.randomUUID().toString(), CommandId.Action.ALTER);
    }

    private static CommandId getStreamCommandId(String streamName) {
        return CommandIdAssigner.getSourceCommandId(CommandId.Type.STREAM, streamName);
    }

    private static CommandId getTableCommandId(String tableName) {
        return CommandIdAssigner.getSourceCommandId(CommandId.Type.TABLE, tableName);
    }

    private static CommandId getSourceCommandId(CommandId.Type type, String sourceName) {
        return new CommandId(type, sourceName, CommandId.Action.CREATE);
    }

    public static CommandId getTerminateClusterCommandId() {
        return new CommandId(CommandId.Type.CLUSTER, "TerminateCluster", CommandId.Action.TERMINATE);
    }

    static interface CommandIdSupplier {
        public CommandId apply(Statement var1);
    }
}

