/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.server.computation.Command;
import io.confluent.ksql.rest.server.computation.QueuedCommand;
import io.confluent.ksql.rest.server.computation.QueuedCommandStatus;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.clients.producer.Producer;

public interface CommandQueue
extends Closeable {
    public QueuedCommandStatus enqueueCommand(CommandId var1, Command var2, Producer<CommandId, Command> var3);

    public List<QueuedCommand> getNewCommands(Duration var1);

    public List<QueuedCommand> getRestoreCommands();

    public void ensureConsumedPast(long var1, Duration var3) throws InterruptedException, TimeoutException;

    public Producer<CommandId, Command> createTransactionalProducer();

    public void abortCommand(CommandId var1);

    public void waitForCommandConsumer();

    public boolean isEmpty();

    public boolean corruptionDetected();

    public void wakeup();

    @Override
    public void close();
}

