/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.entity.CommandStatus;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CommandStatusFuture {
    private static final CommandStatus INITIAL_STATUS = new CommandStatus(CommandStatus.Status.QUEUED, "Statement written to command topic");
    private final CommandId commandId;
    private volatile CommandStatus currentStatus;
    private final CompletableFuture<CommandStatus> finalStatusFuture;

    public CommandStatusFuture(CommandId commandId) {
        this.commandId = Objects.requireNonNull(commandId, "commandId cannot be null");
        this.currentStatus = INITIAL_STATUS;
        this.finalStatusFuture = new CompletableFuture();
    }

    CommandId getCommandId() {
        return this.commandId;
    }

    CommandStatus getStatus() {
        return this.currentStatus;
    }

    CommandStatus tryWaitForFinalStatus(Duration timeout) throws InterruptedException {
        try {
            return this.finalStatusFuture.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException("Error executing command " + String.valueOf(this.commandId), e.getCause());
        }
        catch (TimeoutException e) {
            return this.currentStatus;
        }
    }

    void setStatus(CommandStatus status) {
        this.currentStatus = Objects.requireNonNull(status);
    }

    void setFinalStatus(CommandStatus status) {
        this.setStatus(status);
        this.finalStatusFuture.complete(status);
    }
}

