/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.ksql.execution.json.PlanJsonMapper;
import java.io.IOException;
import java.util.Objects;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;

public final class InternalTopicSerdes {
    private static final ObjectMapper MAPPER = PlanJsonMapper.INSTANCE.get();

    private InternalTopicSerdes() {
    }

    public static <T> Serializer<T> serializer() {
        return new InternalTopicSerializer();
    }

    public static <T> Deserializer<T> deserializer(Class<T> clazz) {
        return new InternalTopicDeserializer<T>(clazz);
    }

    private static final class InternalTopicSerializer<T>
    implements Serializer<T> {
        private InternalTopicSerializer() {
        }

        public byte[] serialize(String topic, T obj) {
            try {
                return MAPPER.writeValueAsBytes(obj);
            }
            catch (IOException e) {
                throw new SerializationException((Throwable)e);
            }
        }
    }

    private static final class InternalTopicDeserializer<T>
    implements Deserializer<T> {
        private final Class<T> clazz;

        private InternalTopicDeserializer(Class<T> clazz) {
            this.clazz = Objects.requireNonNull(clazz, "clazz");
        }

        public T deserialize(String topic, byte[] serialized) {
            try {
                return (T)MAPPER.readValue(serialized, this.clazz);
            }
            catch (IOException e) {
                throw new SerializationException((Throwable)e);
            }
        }
    }
}

