/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.execution.expression.tree.Literal;
import io.confluent.ksql.parser.tree.AssertResource;
import io.confluent.ksql.parser.tree.AssertTopic;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.AssertTopicEntity;
import io.confluent.ksql.rest.server.execution.AssertExecutor;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AssertTopicExecutor {
    private static final Logger LOG = LogManager.getLogger(AssertTopicExecutor.class);

    private AssertTopicExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<AssertTopic> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        return AssertExecutor.execute(statement.getMaskedStatementText(), (AssertResource)statement.getStatement(), executionContext.getKsqlConfig().getInt("ksql.assert.topic.default.timeout.ms"), serviceContext, (stmt, sc) -> AssertTopicExecutor.assertTopic(sc.getTopicClient(), ((AssertTopic)stmt).getTopic(), ((AssertTopic)stmt).getConfig(), stmt.checkExists()), (str, stmt) -> new AssertTopicEntity(str, ((AssertTopic)stmt).getTopic(), stmt.checkExists()));
    }

    private static void assertTopic(KafkaTopicClient client, String topic, Map<String, Literal> config, boolean assertExists) {
        boolean topicExists;
        try {
            topicExists = client.isTopicExists(topic);
        }
        catch (Exception e) {
            throw new KsqlException("Cannot check topic existence: " + e.getMessage());
        }
        if (!assertExists) {
            if (config.size() > 0) {
                LOG.warn("Will skip topic config check for topic non-existence assertion.");
            }
            if (topicExists) {
                throw new KsqlException("Topic " + topic + " exists");
            }
        } else if (topicExists) {
            List partitionList = client.describeTopic(topic).partitions();
            AssertTopicExecutor.checkConfigs(topic, config, partitionList.size(), ((TopicPartitionInfo)partitionList.get(0)).replicas().size());
        } else {
            throw new KsqlException("Topic " + topic + " does not exist");
        }
    }

    private static void checkConfigs(String topic, Map<String, Literal> config, int partitions, int replicas) {
        ArrayList configErrors = new ArrayList();
        config.forEach((k, v) -> {
            if (k.toLowerCase().equals("partitions")) {
                if (!AssertTopicExecutor.configMatches(v.getValue(), partitions)) {
                    configErrors.add(AssertTopicExecutor.createConfigError(topic, "partitions", v.getValue().toString(), partitions));
                }
            } else if (k.toLowerCase().equals("replicas")) {
                if (!AssertTopicExecutor.configMatches(v.getValue(), replicas)) {
                    configErrors.add(AssertTopicExecutor.createConfigError(topic, "replicas", v.getValue().toString(), replicas));
                }
            } else {
                configErrors.add("Cannot assert unknown topic property: " + k);
            }
        });
        if (configErrors.size() > 0) {
            throw new KsqlException(String.join((CharSequence)"\n", configErrors));
        }
    }

    private static boolean configMatches(Object expected, int actual) {
        return expected instanceof Integer && (Integer)expected == actual;
    }

    private static String createConfigError(String topic, String config, String expected, int actual) {
        return String.format("Mismatched configuration for topic %s: For config %s, expected %s got %d", topic, config, expected, actual);
    }
}

