/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.connect.supported.Connectors;
import io.confluent.ksql.parser.tree.CreateConnector;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.ConfigInfos;
import io.confluent.ksql.rest.entity.ConnectorInfo;
import io.confluent.ksql.rest.entity.ConnectorType;
import io.confluent.ksql.rest.entity.CreateConnectorEntity;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.WarningEntity;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import io.confluent.ksql.services.ConnectClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlServerException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class ConnectExecutor {
    private static final ConnectorInfo DUMMY_CREATE_RESPONSE = new ConnectorInfo("dummy", (Map)ImmutableMap.of(), (List)ImmutableList.of(), ConnectorType.UNKNOWN);

    private ConnectExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<CreateConnector> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        ConnectClient client;
        CreateConnector createConnector = (CreateConnector)statement.getStatement();
        Optional<KsqlEntity> connectorsResponse = ConnectExecutor.handleIfNotExists(statement, createConnector, client = serviceContext.getConnectClient());
        if (connectorsResponse.isPresent()) {
            return StatementExecutorResponse.handled(connectorsResponse);
        }
        ConnectClient.ConnectResponse response = client.create(createConnector.getName(), ConnectExecutor.buildConnectorConfig(createConnector));
        if (response.datum().isPresent()) {
            return StatementExecutorResponse.handled(Optional.of(new CreateConnectorEntity(statement.getMaskedStatementText(), (ConnectorInfo)response.datum().get())));
        }
        if (response.error().isPresent()) {
            String errorMsg = "Failed to create connector: " + (String)response.error().get();
            throw new KsqlRestException(EndpointResponse.create().status(response.httpCode()).entity((Object)new KsqlErrorMessage(Errors.toErrorCode((int)response.httpCode()), errorMsg)).build());
        }
        throw new IllegalStateException("Either response.datum() or response.error() must be present");
    }

    public static StatementExecutorResponse validate(ConfiguredStatement<CreateConnector> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        ConnectClient client;
        CreateConnector createConnector = (CreateConnector)statement.getStatement();
        if (ConnectExecutor.checkForExistingConnector(statement, createConnector, client = serviceContext.getConnectClient())) {
            String errorMsg = String.format("Connector %s already exists", createConnector.getName());
            throw new KsqlRestException(EndpointResponse.create().status(409).entity((Object)new KsqlErrorMessage(Errors.toErrorCode((int)409), errorMsg)).build());
        }
        List<String> errors = ConnectExecutor.validateConfigs(createConnector, client);
        if (!errors.isEmpty()) {
            String errorMessage = "Validation error: " + String.join((CharSequence)"\n", errors);
            throw new KsqlException(errorMessage);
        }
        return StatementExecutorResponse.handled(Optional.of(new CreateConnectorEntity(statement.getMaskedStatementText(), DUMMY_CREATE_RESPONSE)));
    }

    private static List<String> validateConfigs(CreateConnector createConnector, ConnectClient client) {
        Map<String, String> config = ConnectExecutor.buildConnectorConfig(createConnector);
        String connectorType = config.get("connector.class");
        if (connectorType == null) {
            return ImmutableList.of((Object)String.format("Connector config %s contains no connector type", config));
        }
        if (connectorType.trim().isEmpty()) {
            return ImmutableList.of((Object)"Connector type cannot be empty");
        }
        ConnectClient.ConnectResponse response = client.validate(connectorType, config);
        if (response.error().isPresent()) {
            return ImmutableList.of((Object)((String)response.error().get()));
        }
        if (response.datum().isPresent()) {
            return ((ConfigInfos)response.datum().get()).values().stream().filter(configInfo -> !configInfo.configValue().errors().isEmpty()).map(configInfo -> configInfo.configValue().name() + " - " + String.join((CharSequence)". ", configInfo.configValue().errors())).collect(Collectors.toList());
        }
        return ImmutableList.of();
    }

    private static Map<String, String> buildConnectorConfig(CreateConnector createConnector) {
        Map config = Connectors.resolve((Map)Maps.transformValues((Map)createConnector.getConfig(), l -> l != null ? l.getValue().toString() : null));
        config.put("name", createConnector.getName());
        return config;
    }

    private static boolean checkForExistingConnector(ConfiguredStatement<CreateConnector> statement, CreateConnector createConnector, ConnectClient client) {
        if (createConnector.ifNotExists()) {
            return false;
        }
        ConnectClient.ConnectResponse connectorsResponse = client.connectors();
        if (connectorsResponse.error().isPresent()) {
            throw new KsqlServerException("Failed to check for existing connector: " + (String)connectorsResponse.error().get());
        }
        return ConnectExecutor.connectorExists(createConnector, (ConnectClient.ConnectResponse<List<String>>)connectorsResponse);
    }

    private static Optional<KsqlEntity> handleIfNotExists(ConfiguredStatement<CreateConnector> statement, CreateConnector createConnector, ConnectClient client) {
        if (createConnector.ifNotExists()) {
            ConnectClient.ConnectResponse connectorsResponse = client.connectors();
            if (connectorsResponse.error().isPresent()) {
                throw new KsqlServerException("Failed to check for existing connector: " + (String)connectorsResponse.error().get());
            }
            if (ConnectExecutor.connectorExists(createConnector, (ConnectClient.ConnectResponse<List<String>>)connectorsResponse)) {
                return Optional.of(new WarningEntity(statement.getMaskedStatementText(), String.format("Connector %s already exists", createConnector.getName())));
            }
        }
        return Optional.empty();
    }

    private static boolean connectorExists(CreateConnector createConnector, ConnectClient.ConnectResponse<List<String>> connectorsResponse) {
        return ((List)connectorsResponse.datum().get()).stream().filter(connector -> StringUtils.equalsIgnoreCase((CharSequence)createConnector.getName(), (CharSequence)connector)).findAny().isPresent();
    }
}

