/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.Explain;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.QueryContainer;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.QueryDescription;
import io.confluent.ksql.rest.entity.QueryDescriptionEntity;
import io.confluent.ksql.rest.entity.QueryDescriptionFactory;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import java.util.Collections;
import java.util.Optional;
import org.apache.kafka.streams.KafkaStreams;

public final class ExplainExecutor {
    private ExplainExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<Explain> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        return StatementExecutorResponse.handled(Optional.of(ExplainExecutor.explain(serviceContext, statement, executionContext, sessionProperties)));
    }

    private static QueryDescriptionEntity explain(ServiceContext serviceContext, ConfiguredStatement<Explain> statement, KsqlExecutionContext executionContext, SessionProperties sessionProperties) {
        Optional queryId = ((Explain)statement.getStatement()).getQueryId();
        try {
            QueryDescription queryDescription = queryId.map(s -> ExplainExecutor.explainQuery(s, executionContext, sessionProperties)).orElseGet(() -> ExplainExecutor.explainStatement(statement, executionContext, serviceContext));
            return new QueryDescriptionEntity(statement.getMaskedStatementText(), queryDescription);
        }
        catch (KsqlException e) {
            throw new KsqlStatementException(e.getMessage(), statement.getMaskedStatementText(), (Throwable)e);
        }
    }

    private static QueryDescription explainStatement(ConfiguredStatement<Explain> explain, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        Statement statement = (Statement)((Explain)explain.getStatement()).getStatement().orElseThrow(() -> new KsqlStatementException("must have either queryID or statement", explain.getMaskedStatementText()));
        if (!(statement instanceof Query) && !(statement instanceof QueryContainer)) {
            throw new KsqlException("The provided statement does not run a ksql query");
        }
        KsqlParser.PreparedStatement preparedStatement = KsqlParser.PreparedStatement.of((String)explain.getUnMaskedStatementText().substring("EXPLAIN ".length()), (Statement)statement);
        KsqlExecutionContext sandbox = executionContext.createSandbox(serviceContext);
        Object metadata = preparedStatement.getStatement() instanceof Query ? sandbox.executeTransientQuery(serviceContext, ConfiguredStatement.of((KsqlParser.PreparedStatement)preparedStatement, (SessionConfig)explain.getSessionConfig()).cast(), false) : (QueryMetadata)sandbox.execute(serviceContext, ConfiguredStatement.of((KsqlParser.PreparedStatement)preparedStatement, (SessionConfig)explain.getSessionConfig())).getQuery().orElseThrow(() -> new IllegalStateException("The provided statement did not run a ksql query"));
        return QueryDescriptionFactory.forQueryMetadata((QueryMetadata)metadata, Collections.emptyMap());
    }

    private static QueryDescription explainQuery(String queryId, KsqlExecutionContext executionContext, SessionProperties sessionProperties) {
        PersistentQueryMetadata metadata = (PersistentQueryMetadata)executionContext.getPersistentQuery(new QueryId(queryId)).orElseThrow(() -> new KsqlException("Query with id:" + queryId + " does not exist, use SHOW QUERIES to view the full set of queries."));
        return QueryDescriptionFactory.forQueryMetadata((QueryMetadata)metadata, Collections.singletonMap(new KsqlHostInfoEntity(sessionProperties.getKsqlHostInfo()), KsqlConstants.fromStreamsState((KafkaStreams.State)metadata.getState())));
    }
}

