/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.parser.tree.ListConnectorPlugins;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.ConnectorPluginsList;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import io.confluent.ksql.services.ConnectClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public final class ListConnectorPluginsExecutor {
    private ListConnectorPluginsExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<ListConnectorPlugins> configuredStatement, SessionProperties sessionProperties, KsqlExecutionContext ksqlExecutionContext, ServiceContext serviceContext) {
        ConnectClient.ConnectResponse plugins = serviceContext.getConnectClient().connectorPlugins();
        if (plugins.error().isPresent()) {
            String errorMsg = "Failed to list connector plugins: " + (String)plugins.error().get();
            throw new KsqlRestException(EndpointResponse.create().status(plugins.httpCode()).entity((Object)new KsqlErrorMessage(Errors.toErrorCode((int)plugins.httpCode()), errorMsg)).build());
        }
        return StatementExecutorResponse.handled(Optional.of(new ConnectorPluginsList(configuredStatement.getMaskedStatementText(), Collections.emptyList(), (List)plugins.datum().get())));
    }
}

