/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.parser.tree.ListFunctions;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.FunctionNameList;
import io.confluent.ksql.rest.entity.FunctionType;
import io.confluent.ksql.rest.entity.SimpleFunctionInfo;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ListFunctionsExecutor {
    private ListFunctionsExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<ListFunctions> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        MetaStore functionRegistry = executionContext.getMetaStore();
        List all = functionRegistry.listFunctions().stream().map(factory -> new SimpleFunctionInfo(factory.getName().toUpperCase(), FunctionType.SCALAR, factory.getMetadata().getCategory())).collect(Collectors.toList());
        functionRegistry.listTableFunctions().stream().map(factory -> new SimpleFunctionInfo(factory.getName().toUpperCase(), FunctionType.TABLE, factory.getMetadata().getCategory())).forEach(all::add);
        functionRegistry.listAggregateFunctions().stream().map(factory -> new SimpleFunctionInfo(factory.getName().toUpperCase(), FunctionType.AGGREGATE, factory.getMetadata().getCategory())).forEach(all::add);
        return StatementExecutorResponse.handled(Optional.of(new FunctionNameList(statement.getMaskedStatementText(), all)));
    }
}

