/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.parser.tree.ListTopics;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.KafkaTopicInfo;
import io.confluent.ksql.rest.entity.KafkaTopicInfoExtended;
import io.confluent.ksql.rest.entity.KafkaTopicsList;
import io.confluent.ksql.rest.entity.KafkaTopicsListExtended;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.KafkaConsumerGroupClient;
import io.confluent.ksql.services.KafkaConsumerGroupClientImpl;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.ReservedInternalTopics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;

public final class ListTopicsExecutor {
    private ListTopicsExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<ListTopics> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        KafkaTopicClient client = serviceContext.getTopicClient();
        Map<String, TopicDescription> topicDescriptions = ListTopicsExecutor.listTopics(client, statement);
        if (((ListTopics)statement.getStatement()).getShowExtended()) {
            KafkaConsumerGroupClientImpl consumerGroupClient = new KafkaConsumerGroupClientImpl(() -> ((ServiceContext)serviceContext).getAdminClient());
            Map<String, List<Integer>> topicConsumersAndGroupCount = ListTopicsExecutor.getTopicConsumerAndGroupCounts((KafkaConsumerGroupClient)consumerGroupClient);
            List topicInfoExtendedList = topicDescriptions.values().stream().map(desc -> ListTopicsExecutor.topicDescriptionToTopicInfoExtended(desc, topicConsumersAndGroupCount)).collect(Collectors.toList());
            return StatementExecutorResponse.handled(Optional.of(new KafkaTopicsListExtended(statement.getMaskedStatementText(), topicInfoExtendedList)));
        }
        List topicInfoList = topicDescriptions.values().stream().map(ListTopicsExecutor::topicDescriptionToTopicInfo).collect(Collectors.toList());
        return StatementExecutorResponse.handled(Optional.of(new KafkaTopicsList(statement.getMaskedStatementText(), topicInfoList)));
    }

    private static Map<String, TopicDescription> listTopics(KafkaTopicClient topicClient, ConfiguredStatement<ListTopics> statement) {
        ReservedInternalTopics internalTopics = new ReservedInternalTopics(statement.getSessionConfig().getConfig(false));
        Set topics = ((ListTopics)statement.getStatement()).getShowAll() ? topicClient.listTopicNames() : internalTopics.removeHiddenTopics(topicClient.listTopicNames());
        return new TreeMap<String, TopicDescription>(topicClient.describeTopics((Collection)topics));
    }

    private static KafkaTopicInfo topicDescriptionToTopicInfo(TopicDescription description) {
        return new KafkaTopicInfo(description.name(), description.partitions().stream().map(partition -> partition.replicas().size()).collect(Collectors.toList()));
    }

    private static KafkaTopicInfoExtended topicDescriptionToTopicInfoExtended(TopicDescription topicDescription, Map<String, List<Integer>> topicConsumersAndGroupCount) {
        List<Integer> consumerAndGroupCount = topicConsumersAndGroupCount.getOrDefault(topicDescription.name(), Arrays.asList(0, 0));
        return new KafkaTopicInfoExtended(topicDescription.name(), topicDescription.partitions().stream().map(partition -> partition.replicas().size()).collect(Collectors.toList()), consumerAndGroupCount.get(0).intValue(), consumerAndGroupCount.get(1).intValue());
    }

    private static Map<String, List<Integer>> getTopicConsumerAndGroupCounts(KafkaConsumerGroupClient consumerGroupClient) {
        List consumerGroups = consumerGroupClient.listGroups();
        HashMap<String, AtomicInteger> topicConsumerCount = new HashMap<String, AtomicInteger>();
        HashMap<String, Set> topicConsumerGroupCount = new HashMap<String, Set>();
        for (String group : consumerGroups) {
            Collection consumerSummaryList = consumerGroupClient.describeConsumerGroup(group).consumers();
            for (KafkaConsumerGroupClient.ConsumerSummary summary : consumerSummaryList) {
                for (TopicPartition topicPartition : summary.partitions()) {
                    topicConsumerCount.computeIfAbsent(topicPartition.topic(), k -> new AtomicInteger()).incrementAndGet();
                    topicConsumerGroupCount.computeIfAbsent(topicPartition.topic(), k -> new HashSet()).add(group);
                }
            }
        }
        HashMap<String, List<Integer>> results = new HashMap<String, List<Integer>>();
        topicConsumerCount.forEach((k, v) -> {
            results.computeIfAbsent((String)k, v1 -> new ArrayList()).add(v.intValue());
            ((List)results.get(k)).add(((Set)topicConsumerGroupCount.get(k)).size());
        });
        return results;
    }
}

