/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.metastore.TypeRegistry;
import io.confluent.ksql.parser.tree.ListTypes;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.TypeList;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.rest.util.EntityUtil;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public final class ListTypesExecutor {
    private ListTypesExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<ListTypes> configuredStatement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        ImmutableMap.Builder types = ImmutableMap.builder();
        Iterator customTypes = executionContext.getMetaStore().types();
        while (customTypes.hasNext()) {
            TypeRegistry.CustomType customType = (TypeRegistry.CustomType)customTypes.next();
            types.put((Object)customType.getName(), (Object)EntityUtil.schemaInfo(customType.getType()));
        }
        return StatementExecutorResponse.handled(Optional.of(new TypeList(configuredStatement.getMaskedStatementText(), (Map)types.build())));
    }
}

