/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.query;

import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.util.PushQueryMetadata;
import io.confluent.ksql.util.ScalablePushQueryMetadata;
import io.confluent.ksql.util.StreamPullQueryMetadata;
import io.confluent.ksql.util.TransientQueryMetadata;
import java.util.Optional;

public final class QueryMetadataHolder {
    private final Optional<TransientQueryMetadata> pushQueryMetadata;
    private final Optional<StreamPullQueryMetadata> streamPullQueryMetadata;
    private final Optional<ScalablePushQueryMetadata> scalablePushQueryMetadata;
    private final Optional<PullQueryResult> pullQueryResult;

    public static QueryMetadataHolder of(TransientQueryMetadata pushQueryMetadata) {
        return new QueryMetadataHolder(Optional.of(pushQueryMetadata), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static QueryMetadataHolder of(StreamPullQueryMetadata streamPullQueryMetadata) {
        return new QueryMetadataHolder(Optional.empty(), Optional.of(streamPullQueryMetadata), Optional.empty(), Optional.empty());
    }

    public static QueryMetadataHolder of(ScalablePushQueryMetadata scalablePushQueryMetadata) {
        return new QueryMetadataHolder(Optional.empty(), Optional.empty(), Optional.of(scalablePushQueryMetadata), Optional.empty());
    }

    public static QueryMetadataHolder of(PullQueryResult pullQueryResult) {
        return new QueryMetadataHolder(Optional.empty(), Optional.empty(), Optional.empty(), Optional.of(pullQueryResult));
    }

    public static QueryMetadataHolder unhandled() {
        return new QueryMetadataHolder(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private QueryMetadataHolder(Optional<TransientQueryMetadata> pushQueryMetadata, Optional<StreamPullQueryMetadata> streamPullQueryMetadata, Optional<ScalablePushQueryMetadata> scalablePushQueryMetadata, Optional<PullQueryResult> pullQueryResult) {
        this.pushQueryMetadata = pushQueryMetadata;
        this.streamPullQueryMetadata = streamPullQueryMetadata;
        this.scalablePushQueryMetadata = scalablePushQueryMetadata;
        this.pullQueryResult = pullQueryResult;
    }

    public Optional<TransientQueryMetadata> getTransientQueryMetadata() {
        return this.pushQueryMetadata;
    }

    public Optional<StreamPullQueryMetadata> getStreamPullQueryMetadata() {
        return this.streamPullQueryMetadata;
    }

    public Optional<ScalablePushQueryMetadata> getScalablePushQueryMetadata() {
        return this.scalablePushQueryMetadata;
    }

    public Optional<PushQueryMetadata> getPushQueryMetadata() {
        if (this.pushQueryMetadata.isPresent()) {
            return this.pushQueryMetadata.map(queryMetadata -> queryMetadata);
        }
        if (this.streamPullQueryMetadata.isPresent()) {
            return this.streamPullQueryMetadata.map(StreamPullQueryMetadata::getTransientQueryMetadata);
        }
        if (this.scalablePushQueryMetadata.isPresent()) {
            return this.scalablePushQueryMetadata.map(queryMetadata -> queryMetadata);
        }
        return Optional.empty();
    }

    public Optional<PullQueryResult> getPullQueryResult() {
        return this.pullQueryResult;
    }
}

