/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import io.confluent.ksql.parser.tree.PrintTopic;
import io.confluent.ksql.services.ConfiguredKafkaClientSupplier;
import io.confluent.ksql.services.ServiceContext;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.BytesDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KafkaClientSupplier;

public final class PrintTopicUtil {
    private PrintTopicUtil() {
    }

    public static KafkaConsumer<Bytes, Bytes> createTopicConsumer(ServiceContext serviceContext, Map<String, Object> consumerProperties, PrintTopic printTopic) {
        KafkaConsumer topicConsumer = new KafkaConsumer(PrintTopicUtil.injectSupplierProperties(serviceContext, consumerProperties), (Deserializer)new BytesDeserializer(), (Deserializer)new BytesDeserializer());
        List topicPartitions = topicConsumer.partitionsFor(printTopic.getTopic()).stream().map(partitionInfo -> new TopicPartition(partitionInfo.topic(), partitionInfo.partition())).collect(Collectors.toList());
        topicConsumer.assign(topicPartitions);
        if (printTopic.getFromBeginning()) {
            topicConsumer.seekToBeginning(topicPartitions);
        }
        return topicConsumer;
    }

    private static Map<String, Object> injectSupplierProperties(ServiceContext serviceContext, Map<String, Object> consumerProperties) {
        KafkaClientSupplier kafkaClientSupplier = serviceContext.getKafkaClientSupplier();
        if (kafkaClientSupplier instanceof ConfiguredKafkaClientSupplier) {
            return ((ConfiguredKafkaClientSupplier)kafkaClientSupplier).injectSupplierProperties(consumerProperties);
        }
        return consumerProperties;
    }
}

