/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.execution.streams.RoutingOptions;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PullQueryConfigRoutingOptions
implements RoutingOptions {
    private final KsqlConfig ksqlConfig;
    private final ImmutableMap<String, ?> configOverrides;
    private final ImmutableMap<String, ?> requestProperties;

    public PullQueryConfigRoutingOptions(KsqlConfig ksqlConfig, Map<String, ?> configOverrides, Map<String, ?> requestProperties) {
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.configOverrides = ImmutableMap.copyOf(configOverrides);
        this.requestProperties = ImmutableMap.copyOf(Objects.requireNonNull(requestProperties, "requestProperties"));
    }

    private long getLong() {
        return Optional.ofNullable((Long)this.configOverrides.get((Object)"ksql.query.pull.max.allowed.offset.lag")).orElse(this.ksqlConfig.getLong("ksql.query.pull.max.allowed.offset.lag"));
    }

    private boolean getForwardedFlag() {
        return Optional.ofNullable((Boolean)this.requestProperties.get((Object)"request.ksql.query.pull.skip.forwarding")).orElse(false);
    }

    public boolean getIsDebugRequest() {
        return Optional.ofNullable((Boolean)this.requestProperties.get((Object)"request.ksql.debug.request")).orElse(false);
    }

    public Set<Integer> getPartitions() {
        if (this.requestProperties.containsKey((Object)"request.ksql.query.pull.partition")) {
            List partitions = Optional.ofNullable((List)this.requestProperties.get((Object)"request.ksql.query.pull.partition")).orElse(Collections.emptyList());
            return partitions.stream().map(partition -> {
                try {
                    return Integer.parseInt(partition);
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("Internal request got a bad partition " + partition);
                }
            }).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public long getMaxOffsetLagAllowed() {
        return this.getLong();
    }

    public boolean getIsSkipForwardRequest() {
        return this.getForwardedFlag();
    }
}

