/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.rest.entity.PushContinuationToken;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.rest.server.resources.streaming.Flow;
import io.confluent.ksql.rest.server.resources.streaming.PollingSubscription;
import io.confluent.ksql.rest.server.resources.streaming.WebSocketSubscriber;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.PushOffsetRange;
import io.confluent.ksql.util.PushQueryMetadata;
import io.confluent.ksql.util.RowMetadata;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class PushQueryPublisher
implements Flow.Publisher<Collection<StreamedRow>> {
    private static final Logger log = LogManager.getLogger(PushQueryPublisher.class);
    private final ListeningScheduledExecutorService exec;
    private final PushQueryMetadata queryMetadata;
    private final MetricsCallbackHolder metricsCallbackHolder;
    private final long startTimeNanos;

    PushQueryPublisher(ListeningScheduledExecutorService exec, PushQueryMetadata queryMetadata, MetricsCallbackHolder metricsCallbackHolder, long startTimeNanos) {
        this.exec = exec;
        this.queryMetadata = queryMetadata;
        this.metricsCallbackHolder = metricsCallbackHolder;
        this.startTimeNanos = startTimeNanos;
    }

    @Override
    public synchronized void subscribe(Flow.Subscriber<Collection<StreamedRow>> subscriber) {
        PushQuerySubscription subscription = new PushQuerySubscription(this.exec, subscriber, this.queryMetadata);
        log.info("Running query {}", (Object)this.queryMetadata.getQueryId().toString());
        this.queryMetadata.start();
        WebSocketSubscriber webSocketSubscriber = (WebSocketSubscriber)subscriber;
        webSocketSubscriber.onSubscribe(subscription, this.metricsCallbackHolder, this.startTimeNanos);
    }

    private static LogicalSchema valueColumnOnly(LogicalSchema logicalSchema) {
        LogicalSchema.Builder builder = LogicalSchema.builder();
        logicalSchema.value().forEach(arg_0 -> ((LogicalSchema.Builder)builder).valueColumn(arg_0));
        return builder.build();
    }

    static class PushQuerySubscription
    extends PollingSubscription<Collection<StreamedRow>> {
        private final PushQueryMetadata queryMetadata;
        private boolean closed = false;

        PushQuerySubscription(ListeningScheduledExecutorService exec, Flow.Subscriber<Collection<StreamedRow>> subscriber, PushQueryMetadata queryMetadata) {
            super(exec, subscriber, PushQueryPublisher.valueColumnOnly(queryMetadata.getLogicalSchema()));
            this.queryMetadata = Objects.requireNonNull(queryMetadata, "queryMetadata");
            queryMetadata.setLimitHandler(this::setDone);
            queryMetadata.setCompletionHandler(this::setDone);
            queryMetadata.setUncaughtExceptionHandler(e -> {
                this.setError(e);
                return StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse.SHUTDOWN_CLIENT;
            });
        }

        @Override
        public Collection<StreamedRow> poll() {
            LinkedList rows = Lists.newLinkedList();
            this.queryMetadata.getRowQueue().drainTo((Collection)rows);
            if (rows.isEmpty()) {
                return null;
            }
            return rows.stream().map(kv -> {
                if (kv.getRowMetadata().isPresent() && ((RowMetadata)kv.getRowMetadata().get()).getPushOffsetsRange().isPresent()) {
                    return StreamedRow.continuationToken((PushContinuationToken)new PushContinuationToken(((PushOffsetRange)((RowMetadata)kv.getRowMetadata().get()).getPushOffsetsRange().get()).serialize()));
                }
                return StreamedRow.pushRow((GenericRow)((GenericRow)kv.getKeyValue().value()));
            }).collect(Collectors.toCollection(Lists::newLinkedList));
        }

        @Override
        public synchronized void close() {
            if (!this.closed) {
                this.closed = true;
                log.info("Terminating query {}", (Object)this.queryMetadata.getQueryId().toString());
                this.queryMetadata.close();
            }
        }
    }
}

