/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.server.StreamingOutput;
import io.confluent.ksql.query.BlockingRowQueue;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.PushContinuationToken;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.rest.server.resources.streaming.TombstoneFactory;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KeyValueMetadata;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.PushOffsetRange;
import io.confluent.ksql.util.PushQueryMetadata;
import io.confluent.ksql.util.RowMetadata;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.streams.errors.StreamsUncaughtExceptionHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class QueryStreamWriter
implements StreamingOutput {
    private static final int WRITE_TIMEOUT_MS = 600000;
    private static final Logger log = LogManager.getLogger(QueryStreamWriter.class);
    private final PushQueryMetadata queryMetadata;
    private final long disconnectCheckInterval;
    private final ObjectMapper objectMapper;
    private final TombstoneFactory tombstoneFactory;
    private volatile Exception streamsException;
    private volatile boolean limitReached = false;
    private volatile boolean complete;
    private volatile boolean connectionClosed;
    private boolean closed;

    QueryStreamWriter(PushQueryMetadata queryMetadata, long disconnectCheckInterval, ObjectMapper objectMapper, CompletableFuture<Void> connectionClosedFuture) {
        this(queryMetadata, disconnectCheckInterval, objectMapper, connectionClosedFuture, false);
    }

    QueryStreamWriter(PushQueryMetadata queryMetadata, long disconnectCheckInterval, ObjectMapper objectMapper, CompletableFuture<Void> connectionClosedFuture, boolean emptyStream) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        this.disconnectCheckInterval = disconnectCheckInterval;
        this.queryMetadata = Objects.requireNonNull(queryMetadata, "queryMetadata");
        this.queryMetadata.setLimitHandler(() -> {
            this.limitReached = true;
        });
        this.queryMetadata.setCompletionHandler(() -> {
            this.complete = true;
        });
        this.queryMetadata.setUncaughtExceptionHandler((StreamsUncaughtExceptionHandler)new StreamsExceptionHandler());
        this.tombstoneFactory = TombstoneFactory.create(queryMetadata.getLogicalSchema(), queryMetadata.getResultType());
        connectionClosedFuture.thenAccept(v -> {
            this.connectionClosed = true;
        });
        if (emptyStream) {
            this.complete = true;
        } else {
            queryMetadata.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream out) {
        try {
            out.write("[".getBytes(StandardCharsets.UTF_8));
            this.write(out, this.buildHeader());
            BlockingRowQueue rowQueue = this.queryMetadata.getRowQueue();
            while (!this.connectionClosed && this.queryMetadata.isRunning() && !this.limitReached && !this.complete) {
                KeyValueMetadata row = rowQueue.poll(this.disconnectCheckInterval, TimeUnit.MILLISECONDS);
                if (row != null) {
                    this.write(out, this.buildRow(row));
                } else {
                    out.write("\n".getBytes(StandardCharsets.UTF_8));
                    out.flush();
                }
                this.drainAndThrowOnError(out);
            }
            if (this.connectionClosed) {
                return;
            }
            this.drain(out);
            if (this.limitReached) {
                this.objectMapper.writeValue(out, (Object)StreamedRow.finalMessage((String)"Limit Reached"));
            } else if (this.complete) {
                this.objectMapper.writeValue(out, (Object)StreamedRow.finalMessage((String)"Query Completed"));
            }
            out.write("]\n".getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (EOFException exception) {
            log.warn("Query terminated due to exception:" + exception.toString());
        }
        catch (InterruptedException exception) {
            log.warn("Interrupted while writing to connection stream");
        }
        catch (Exception exception) {
            log.error("Exception occurred while writing to connection stream: ", (Throwable)exception);
            this.outputException(out, exception);
        }
        finally {
            this.close();
        }
    }

    private void write(OutputStream output, StreamedRow row) throws IOException {
        this.objectMapper.writeValue(output, (Object)row);
        output.write(",\n".getBytes(StandardCharsets.UTF_8));
        output.flush();
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.queryMetadata.close();
            this.closed = true;
        }
    }

    @Override
    public int getWriteTimeoutMs() {
        return 600000;
    }

    private StreamedRow buildHeader() {
        QueryId queryId = this.queryMetadata.getQueryId();
        LogicalSchema storedSchema = this.queryMetadata.getLogicalSchema();
        LogicalSchema.Builder projectionSchema = LogicalSchema.builder();
        storedSchema.value().forEach(arg_0 -> ((LogicalSchema.Builder)projectionSchema).valueColumn(arg_0));
        return StreamedRow.header((QueryId)queryId, (LogicalSchema)projectionSchema.build());
    }

    private StreamedRow buildRow(KeyValueMetadata<List<?>, GenericRow> row) {
        if (row.getRowMetadata().isPresent() && ((RowMetadata)row.getRowMetadata().get()).getPushOffsetsRange().isPresent()) {
            return StreamedRow.continuationToken((PushContinuationToken)new PushContinuationToken(((PushOffsetRange)((RowMetadata)row.getRowMetadata().get()).getPushOffsetsRange().get()).serialize()));
        }
        if (row.getKeyValue().value() == null) {
            return StreamedRow.tombstone((GenericRow)this.tombstoneFactory.createRow(row.getKeyValue()));
        }
        return StreamedRow.pushRow((GenericRow)((GenericRow)row.getKeyValue().value()));
    }

    private void outputException(OutputStream out, Throwable exception) {
        try {
            out.write("\n".getBytes(StandardCharsets.UTF_8));
            if (exception.getCause() instanceof KsqlException) {
                this.objectMapper.writeValue(out, (Object)StreamedRow.error((Throwable)exception.getCause(), (int)Errors.ERROR_CODE_SERVER_ERROR));
            } else {
                this.objectMapper.writeValue(out, (Object)StreamedRow.error((Throwable)exception, (int)Errors.ERROR_CODE_SERVER_ERROR));
            }
            out.write(",\n".getBytes(StandardCharsets.UTF_8));
            out.flush();
        }
        catch (IOException e) {
            log.debug("Client disconnected while attempting to write an error message");
        }
    }

    private void drainAndThrowOnError(OutputStream out) throws Exception {
        if (this.streamsException != null) {
            this.drain(out);
            throw this.streamsException;
        }
    }

    private void drain(OutputStream out) throws IOException {
        ArrayList rows = Lists.newArrayList();
        this.queryMetadata.getRowQueue().drainTo((Collection)rows);
        for (KeyValueMetadata row : rows) {
            this.write(out, this.buildRow(row));
        }
    }

    private class StreamsExceptionHandler
    implements StreamsUncaughtExceptionHandler {
        private StreamsExceptionHandler() {
        }

        public StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse handle(Throwable throwable) {
            QueryStreamWriter.this.streamsException = throwable instanceof Exception ? (Exception)throwable : new RuntimeException(throwable);
            return StreamsUncaughtExceptionHandler.StreamThreadExceptionResponse.SHUTDOWN_CLIENT;
        }
    }
}

