/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.services;

import io.confluent.ksql.reactive.BufferedPublisher;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.entity.ClusterStatusResponse;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.entity.LagReportingMessage;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.rest.server.resources.KsqlResource;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.services.SimpleKsqlClient;
import io.confluent.ksql.util.KsqlHostInfo;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.streams.WriteStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class ServerInternalKsqlClient
implements SimpleKsqlClient {
    private final KsqlResource ksqlResource;
    private final KsqlSecurityContext securityContext;

    public ServerInternalKsqlClient(KsqlResource ksqlResource, KsqlSecurityContext securityContext) {
        this.ksqlResource = Objects.requireNonNull(ksqlResource, "ksqlResource");
        this.securityContext = Objects.requireNonNull(securityContext, "securityContext");
    }

    public RestResponse<KsqlEntityList> makeKsqlRequest(URI serverEndpoint, String sql, Map<String, ?> requestProperties) {
        KsqlRequest request = new KsqlRequest(sql, Collections.emptyMap(), requestProperties, null);
        EndpointResponse response = this.ksqlResource.handleKsqlStatements(this.securityContext, request);
        int status = response.getStatus();
        if (status == HttpResponseStatus.OK.code()) {
            return RestResponse.successful((int)status, (Object)((KsqlEntityList)response.getEntity()));
        }
        return RestResponse.erroneous((int)status, (KsqlErrorMessage)((KsqlErrorMessage)response.getEntity()));
    }

    public RestResponse<List<StreamedRow>> makeQueryRequest(URI serverEndpoint, String sql, Map<String, ?> configOverrides, Map<String, ?> requestProperties) {
        throw new UnsupportedOperationException();
    }

    public RestResponse<Integer> makeQueryRequest(URI serverEndpoint, String sql, Map<String, ?> configOverrides, Map<String, ?> requestProperties, WriteStream<List<StreamedRow>> rowConsumer, CompletableFuture<Void> shouldCloseConnection, Function<StreamedRow, StreamedRow> addHostInfo) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<RestResponse<BufferedPublisher<StreamedRow>>> makeQueryRequestStreamed(URI serverEndPoint, String sql, Map<String, ?> configOverrides, Map<String, ?> requestProperties) {
        throw new UnsupportedOperationException();
    }

    public void makeAsyncHeartbeatRequest(URI serverEndPoint, KsqlHostInfo host, long timestamp) {
        throw new UnsupportedOperationException();
    }

    public RestResponse<ClusterStatusResponse> makeClusterStatusRequest(URI serverEndPoint) {
        throw new UnsupportedOperationException();
    }

    public void makeAsyncLagReportRequest(URI serverEndPoint, LagReportingMessage lagReportingMessage) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

