/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.validation;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.CreateAsSelect;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.PauseQuery;
import io.confluent.ksql.parser.tree.ResumeQuery;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.parser.tree.TerminateQuery;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.server.computation.ValidatedCommandFactory;
import io.confluent.ksql.rest.server.validation.StatementValidator;
import io.confluent.ksql.rest.util.QueryCapacityUtil;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.SandboxUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public class RequestValidator {
    private final Map<Class<? extends Statement>, StatementValidator<?>> customValidators;
    private final BiFunction<KsqlExecutionContext, ServiceContext, Injector> injectorFactory;
    private final Function<ServiceContext, KsqlExecutionContext> snapshotSupplier;
    private final ValidatedCommandFactory distributedStatementValidator;

    public RequestValidator(Map<Class<? extends Statement>, StatementValidator<?>> customValidators, BiFunction<KsqlExecutionContext, ServiceContext, Injector> injectorFactory, Function<ServiceContext, KsqlExecutionContext> snapshotSupplier, ValidatedCommandFactory distributedStatementValidator) {
        this.customValidators = Objects.requireNonNull(customValidators, "customValidators");
        this.injectorFactory = Objects.requireNonNull(injectorFactory, "injectorFactory");
        this.snapshotSupplier = Objects.requireNonNull(snapshotSupplier, "snapshotSupplier");
        this.distributedStatementValidator = Objects.requireNonNull(distributedStatementValidator, "distributedStatementValidator");
    }

    private boolean isVariableSubstitutionEnabled(SessionProperties sessionProperties, KsqlConfig ksqlConfig) {
        Object substitutionEnabled = sessionProperties.getMutableScopedProperties().get("ksql.variable.substitution.enable");
        if (substitutionEnabled != null && substitutionEnabled instanceof Boolean) {
            return (Boolean)substitutionEnabled;
        }
        return ksqlConfig.getBoolean("ksql.variable.substitution.enable");
    }

    public int validate(ServiceContext serviceContext, List<KsqlParser.ParsedStatement> statements, SessionProperties sessionProperties, String sql) {
        SandboxUtil.requireSandbox((Object)serviceContext);
        KsqlExecutionContext ctx = (KsqlExecutionContext)SandboxUtil.requireSandbox((Object)this.snapshotSupplier.apply(serviceContext));
        Injector injector = this.injectorFactory.apply(ctx, serviceContext);
        KsqlConfig ksqlConfig = ctx.getKsqlConfig();
        int numPersistentQueries = 0;
        for (KsqlParser.ParsedStatement parsed : statements) {
            KsqlParser.PreparedStatement prepared = ctx.prepare(parsed, this.isVariableSubstitutionEnabled(sessionProperties, ksqlConfig) ? sessionProperties.getSessionVariables() : Collections.emptyMap());
            ConfiguredStatement configured = ConfiguredStatement.of((KsqlParser.PreparedStatement)prepared, (SessionConfig)SessionConfig.of((KsqlConfig)ksqlConfig, (Map)sessionProperties.getMutableScopedProperties()));
            int currNumPersistentQueries = this.validate(serviceContext, configured, sessionProperties, ctx, injector);
            numPersistentQueries += currNumPersistentQueries;
            if (currNumPersistentQueries <= 0 || !QueryCapacityUtil.exceedsPersistentQueryCapacity(ctx, ksqlConfig)) continue;
            QueryCapacityUtil.throwTooManyActivePersistentQueriesException(ctx, ksqlConfig, sql);
        }
        return numPersistentQueries;
    }

    private <T extends Statement> int validate(ServiceContext serviceContext, ConfiguredStatement<T> configured, SessionProperties sessionProperties, KsqlExecutionContext executionContext, Injector injector) throws KsqlStatementException {
        Statement statement = configured.getStatement();
        Class<?> statementClass = statement.getClass();
        StatementValidator<?> customValidator = this.customValidators.get(statementClass);
        if (customValidator != null) {
            customValidator.validate(configured, sessionProperties, executionContext, serviceContext);
        } else if (KsqlEngine.isExecutableStatement((Statement)configured.getStatement()) || configured.getStatement() instanceof PauseQuery || configured.getStatement() instanceof ResumeQuery || configured.getStatement() instanceof TerminateQuery) {
            ConfiguredStatement statementInjected = injector.inject(configured);
            this.distributedStatementValidator.create((ConfiguredStatement<? extends Statement>)statementInjected, serviceContext, executionContext);
        } else {
            throw new KsqlStatementException("Do not know how to validate statement of type: " + String.valueOf(statementClass) + " Known types: " + String.valueOf(this.customValidators.keySet()), configured.getMaskedStatementText());
        }
        return statement instanceof CreateAsSelect || statement instanceof InsertInto ? 1 : 0;
    }
}

