/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.util.KsqlHostInfo;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryMetadata;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.state.HostInfo;

public final class DiscoverRemoteHostsUtil {
    private DiscoverRemoteHostsUtil() {
    }

    public static Set<HostInfo> getRemoteHosts(List<PersistentQueryMetadata> currentQueries, KsqlHostInfo localHost) {
        return currentQueries.stream().filter(q -> q.getState().isRunningOrRebalancing()).map(QueryMetadata::getAllStreamsHostMetadata).filter(Objects::nonNull).flatMap(Collection::stream).map(StreamsMetadata::hostInfo).filter(hostInfo -> !hostInfo.host().equals(localHost.host()) || hostInfo.port() != localHost.port()).collect(Collectors.toSet());
    }
}

