/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.config.SessionConfig;
import io.confluent.ksql.parser.tree.ColumnConstraints;
import io.confluent.ksql.parser.tree.CreateSource;
import io.confluent.ksql.parser.tree.TableElement;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;

public final class FeatureFlagChecker {
    private FeatureFlagChecker() {
    }

    public static void throwOnDisabledFeatures(ConfiguredStatement<?> statement) {
        SessionConfig sessionConfig = statement.getSessionConfig();
        if (statement.getStatement() instanceof CreateSource) {
            FeatureFlagChecker.throwOnDisabledFeatures((CreateSource)statement.getStatement(), sessionConfig);
        }
    }

    private static void throwOnDisabledFeatures(CreateSource createSource, SessionConfig sessionConfig) {
        boolean anyHeaderFound;
        KsqlConfig ksqlConfig = sessionConfig.getConfig(false);
        if (!ksqlConfig.getBoolean("ksql.headers.columns.enabled").booleanValue() && (anyHeaderFound = createSource.getElements().stream().map(TableElement::getConstraints).anyMatch(ColumnConstraints::isHeaders))) {
            throw new KsqlException(String.format("Cannot create %s because schema with headers columns is disabled.", createSource.getSourceType()));
        }
    }
}

