/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.analyzer.ImmutableAnalysis;
import io.confluent.ksql.api.server.MetricsCallback;
import io.confluent.ksql.api.server.SlidingWindowRateLimiter;
import io.confluent.ksql.execution.pull.PullPhysicalPlan;
import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.internal.PullQueryExecutorMetrics;
import io.confluent.ksql.internal.ScalablePushQueryMetrics;
import io.confluent.ksql.query.TransientQueryQueue;
import io.confluent.ksql.rest.util.ConcurrencyLimiter;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.ScalablePushQueryMetadata;
import io.confluent.ksql.util.StreamPullQueryMetadata;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.streams.KafkaStreams;

public final class QueryMetricsUtil {
    private QueryMetricsUtil() {
    }

    public static MetricsCallback initializePullTableMetricsCallback(Optional<PullQueryExecutorMetrics> pullQueryMetrics, SlidingWindowRateLimiter pullBandRateLimiter, AtomicReference<PullQueryResult> resultForMetrics) {
        MetricsCallback metricsCallback = (statusCode, requestBytes, responseBytes, startTimeNanos) -> pullQueryMetrics.ifPresent(metrics -> {
            metrics.recordStatusCode(statusCode);
            metrics.recordRequestSize((double)requestBytes);
            PullQueryResult r = (PullQueryResult)resultForMetrics.get();
            if (r == null) {
                QueryMetricsUtil.recordErrorMetrics(pullQueryMetrics, responseBytes, startTimeNanos);
            } else {
                KsqlConstants.QuerySourceType sourceType = r.getSourceType();
                PullPhysicalPlan.PullPhysicalPlanType planType = r.getPlanType();
                KsqlConstants.RoutingNodeType routingNodeType = KsqlConstants.RoutingNodeType.SOURCE_NODE;
                metrics.recordResponseSize((double)responseBytes, sourceType, planType, routingNodeType);
                metrics.recordLatency(startTimeNanos, sourceType, planType, routingNodeType);
                metrics.recordRowsReturned((double)r.getTotalRowsReturned(), sourceType, planType, routingNodeType);
                metrics.recordRowsProcessed((double)r.getTotalRowsProcessed(), sourceType, planType, routingNodeType);
            }
            pullBandRateLimiter.add(responseBytes);
        });
        return metricsCallback;
    }

    public static MetricsCallback initializePullStreamMetricsCallback(Optional<PullQueryExecutorMetrics> pullQueryMetrics, SlidingWindowRateLimiter pullBandRateLimiter, ImmutableAnalysis analysis, AtomicReference<StreamPullQueryMetadata> resultForMetrics, AtomicReference<ConcurrencyLimiter.Decrementer> refDecrementer) {
        MetricsCallback metricsCallback = (statusCode, requestBytes, responseBytes, startTimeNanos) -> pullQueryMetrics.ifPresent(metrics -> {
            KafkaStreams.State state;
            metrics.recordStatusCode(statusCode);
            metrics.recordRequestSize((double)requestBytes);
            StreamPullQueryMetadata m = (StreamPullQueryMetadata)resultForMetrics.get();
            KafkaStreams.State state2 = state = m == null ? null : m.getTransientQueryMetadata().getKafkaStreams().state();
            if (m == null || state == null || state.equals((Object)KafkaStreams.State.ERROR) || state.equals((Object)KafkaStreams.State.PENDING_ERROR)) {
                QueryMetricsUtil.recordErrorMetrics(pullQueryMetrics, responseBytes, startTimeNanos);
            } else {
                boolean isWindowed = analysis.getFrom().getDataSource().getKsqlTopic().getKeyFormat().isWindowed();
                KsqlConstants.QuerySourceType sourceType = isWindowed ? KsqlConstants.QuerySourceType.WINDOWED_STREAM : KsqlConstants.QuerySourceType.NON_WINDOWED_STREAM;
                PullPhysicalPlan.PullPhysicalPlanType planType = PullPhysicalPlan.PullPhysicalPlanType.UNKNOWN;
                KsqlConstants.RoutingNodeType routingNodeType = KsqlConstants.RoutingNodeType.SOURCE_NODE;
                metrics.recordResponseSize((double)responseBytes, sourceType, planType, routingNodeType);
                metrics.recordLatency(startTimeNanos, sourceType, planType, routingNodeType);
                TransientQueryQueue rowQueue = (TransientQueryQueue)m.getTransientQueryMetadata().getRowQueue();
                metrics.recordRowsReturned((double)rowQueue.getTotalRowsQueued(), sourceType, planType, routingNodeType);
                metrics.recordRowsProcessed((double)rowQueue.getTotalRowsQueued(), sourceType, planType, routingNodeType);
            }
            pullBandRateLimiter.add(responseBytes);
            ConcurrencyLimiter.Decrementer decrementer = (ConcurrencyLimiter.Decrementer)refDecrementer.get();
            if (decrementer != null) {
                decrementer.decrementAtMostOnce();
            }
        });
        return metricsCallback;
    }

    public static MetricsCallback initializeScalablePushMetricsCallback(Optional<ScalablePushQueryMetrics> scalablePushQueryMetrics, SlidingWindowRateLimiter scalablePushBandRateLimiter, AtomicReference<ScalablePushQueryMetadata> resultForMetrics) {
        MetricsCallback metricsCallback = (statusCode, requestBytes, responseBytes, startTimeNanos) -> scalablePushQueryMetrics.ifPresent(metrics -> {
            metrics.recordStatusCode(statusCode);
            metrics.recordRequestSize((double)requestBytes);
            ScalablePushQueryMetadata r = (ScalablePushQueryMetadata)resultForMetrics.get();
            if (r == null) {
                metrics.recordResponseSizeForError(responseBytes);
                metrics.recordConnectionDurationForError(startTimeNanos);
                metrics.recordZeroRowsReturnedForError();
                metrics.recordZeroRowsProcessedForError();
            } else {
                KsqlConstants.QuerySourceType sourceType = r.getSourceType();
                KsqlConstants.RoutingNodeType routingNodeType = r.getRoutingNodeType();
                metrics.recordResponseSize((double)responseBytes, sourceType, routingNodeType);
                metrics.recordConnectionDuration(startTimeNanos, sourceType, routingNodeType);
                metrics.recordRowsReturned((double)r.getTotalRowsReturned(), sourceType, routingNodeType);
                metrics.recordRowsProcessed((double)r.getTotalRowsProcessed(), sourceType, routingNodeType);
            }
            scalablePushBandRateLimiter.add(responseBytes);
        });
        return metricsCallback;
    }

    private static void recordErrorMetrics(Optional<PullQueryExecutorMetrics> pullQueryMetrics, long responseBytes, long startTimeNanos) {
        pullQueryMetrics.ifPresent(metrics -> {
            metrics.recordResponseSizeForError(responseBytes);
            metrics.recordLatencyForError(startTimeNanos);
            metrics.recordZeroRowsReturnedForError();
            metrics.recordZeroRowsProcessedForError();
        });
    }
}

